package com.xforceplus.elephant.image.controller.batch;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.batch.process.EnableFlowProcess;
import com.xforceplus.elephant.image.controller.batch.process.GetBatchTaskProcess;
import com.xforceplus.elephant.image.core.business.application.collect.batch.domain.BatchBean;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;

@Slf4j
@ApiV1Image
@RequiredArgsConstructor
public class BatchController extends BaseController {

    private final EnableFlowProcess enableFlowProcess;
    private final GetBatchTaskProcess getBatchTaskProcess;

    @GetMapping("/batch/enable")
    public CommonResponse<Boolean> enable(BaseRequest request) {
        return enableFlowProcess.execute(request);
    }

    @GetMapping("/batch/list")
    public CommonResponse<BatchBean> getBatchList(BaseRequest request) {
        return getBatchTaskProcess.execute(request);
    }

}
