package com.xforceplus.elephant.image.controller.batchnumberrule;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.BatchNumberRuleApi;
import com.xforceplus.elephant.image.client.model.CheckRuleCodeRepeatRequest;
import com.xforceplus.elephant.image.client.model.GetBatchNumberRuleRequest;
import com.xforceplus.elephant.image.client.model.GetSerialNumberRequest;
import com.xforceplus.elephant.image.client.model.SaveBatchNumberRuleRequest;
import com.xforceplus.elephant.image.client.model.SaveSerialNumberRequest;
import com.xforceplus.elephant.image.client.model.UpdateBatchNumberRuleRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.batchnumberrule.process.CheckRuleCodeRepeatProcess;
import com.xforceplus.elephant.image.controller.batchnumberrule.process.GetBatchNumberRuleProcess;
import com.xforceplus.elephant.image.controller.batchnumberrule.process.GetRuleCodeConfigProcess;
import com.xforceplus.elephant.image.controller.batchnumberrule.process.SaveBatchNumberRuleProcess;
import com.xforceplus.elephant.image.controller.batchnumberrule.process.UpdateBatchNumberRuleProcess;
import com.xforceplus.elephant.image.controller.batchnumberrule.process.autonomous.GetNoRuleSerialNumberProcess;
import com.xforceplus.elephant.image.controller.batchnumberrule.process.autonomous.GetSerialNumberProcess;
import com.xforceplus.elephant.image.controller.batchnumberrule.process.autonomous.SaveSerialNumberForceProcess;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class BatchNumberRuleController extends BaseController implements BatchNumberRuleApi {

    @Autowired
    private SaveBatchNumberRuleProcess saveBatchNumberRuleProcess;

    @Autowired
    private UpdateBatchNumberRuleProcess updateBatchNumberRuleProcess;

    @Autowired
    private GetSerialNumberProcess getSerialNumberProcess;

    @Autowired
    private GetNoRuleSerialNumberProcess getNoRuleSerialNumberProcess;

    @Autowired
    private GetBatchNumberRuleProcess getBatchNumberRuleProcess;

    @Autowired
    private CheckRuleCodeRepeatProcess checkRuleCodeRepeatProcess;

    @Autowired
    private SaveSerialNumberForceProcess saveSerialNumberForceProcess;

    @Autowired
    private GetRuleCodeConfigProcess getRuleCodeConfigProcess;

    @Override
    public CommonResponse addBatchNumberRule(@RequestBody SaveBatchNumberRuleRequest request) {
        return saveBatchNumberRuleProcess.execute(request);
    }

    @Override
    public CommonResponse editBatchNumberRule(@RequestBody UpdateBatchNumberRuleRequest request) {
        return updateBatchNumberRuleProcess.execute(request);
    }

    @Override
    public CommonResponse checkRepeatByCode(@Valid CheckRuleCodeRepeatRequest request) {
        return checkRuleCodeRepeatProcess.execute(request);
    }

    @Override
    public CommonResponse getBatchNumberRule(@Valid GetBatchNumberRuleRequest request) {
        return getBatchNumberRuleProcess.execute(request);
    }

    @Override
    public CommonResponse getSerialNumber(@Valid GetSerialNumberRequest request) {
        return getSerialNumberProcess.execute(request);
    }

    @Override
    public CommonResponse saveSerialNumber(@RequestBody SaveSerialNumberRequest request) {
        return saveSerialNumberForceProcess.execute(request);
    }

    @Override
    public CommonResponse getRuleCodeConfig() {
        return getRuleCodeConfigProcess.getRuleCodeConfig();
    }

    @Override
    public CommonResponse getEnumsConfig() {
        return getRuleCodeConfigProcess.getEnumsConfig();
    }

    @Override
    public CommonResponse getEnumDetailsConfig(@RequestParam("enumValue") String enumValue) {
        return getRuleCodeConfigProcess.getEnumDetailsConfig(enumValue);
    }

    @Override
    public CommonResponse batchGetEnumDetailsConfig(@RequestParam("enumValues") String[] enumValues) {
        return getRuleCodeConfigProcess.getEnumDetailsConfig(enumValues);
    }

    @Override
    public CommonResponse getNoRuleSerialNumber(GetSerialNumberRequest request) {
        return getNoRuleSerialNumberProcess.execute(request);
    }

}
