package com.xforceplus.elephant.image.controller.batchnumberrule.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.CheckRuleCodeRepeatRequest;
import com.xforceplus.elephant.image.core.facade.application.calculate.batchnumberrule.BatchNumberRuleFacade;
import com.xforceplus.elephant.image.core.repository.model.BatchNumberRuleEntity;
import javax.validation.ValidationException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class CheckRuleCodeRepeatProcess extends AbstractProcess<CheckRuleCodeRepeatRequest, Boolean> {

    @Autowired
    private BatchNumberRuleFacade batchNumberRuleFacade;

    @Override
    protected void check(CheckRuleCodeRepeatRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getRuleCode(), "规则编号不能为空!");
        checkEmpty(request.getTenantId(), "租户不能为空!");
    }

    @Override
    protected CommonResponse<Boolean> process(CheckRuleCodeRepeatRequest request) throws RuntimeException {
        //true 代表存在 新增修改一起校验
        boolean result = false;
        final BatchNumberRuleEntity batchNumberRuleEntity = batchNumberRuleFacade.selectByCode(request.getRuleCode(), request.getTenantId());
        if (ValidatorUtil.isNotEmpty(request.getRuleId())) {
            if (batchNumberRuleEntity != null && !request.getRuleId().equals(batchNumberRuleEntity.getId())) {
                result = true;
            }
        } else {
            if (batchNumberRuleEntity != null) {
                result = true;
            }
        }
        return CommonResponse.ok("成功", result);
    }

}
