package com.xforceplus.elephant.image.controller.batchnumberrule.process;

import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.SaveBatchNumberRuleRequest;
import com.xforceplus.elephant.image.core.repository.model.BatchNumberRuleEntity;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.validation.ValidationException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class SaveBatchNumberRuleProcess extends AbstractBatchNumberRuleProcess<SaveBatchNumberRuleRequest, Long> {

    @Override
    protected void check(SaveBatchNumberRuleRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getRuleCode(), "规则编号不能为空!");
        checkEmpty(request.getRuleName(), "规则名称不能为空!");
        checkEmpty(request.getRuleDefine(), "规则定义不能为空!");
        //checkEmpty(request.getTenant(),"所属租户不能为空!");
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        //从后端取租户，防止篡改
        request.setTenant(String.valueOf(authorizedUser.getTenantId()));
        //校验规则名称不能重复
        final BatchNumberRuleEntity batchNumberRuleEntity = batchNumberRuleFacade.selectByName(request.getRuleName(), authorizedUser.getTenantId());
        if (batchNumberRuleEntity != null) {
            throw new ValidationException("规则名称重复");
        }
        final BatchNumberRuleEntity codeBatchNumberRuleEntity = batchNumberRuleFacade.selectByCode(request.getRuleCode(), authorizedUser.getTenantId());
        if (codeBatchNumberRuleEntity != null) {
            throw new ValidationException("规则编号重复");
        }
    }

    @Override
    protected CommonResponse<Long> process(SaveBatchNumberRuleRequest request) throws RuntimeException {
        final Long ruleId = batchNumberRuleFacade.insertBatchNumberRule(BeanUtils.convertJSON(request));
        return CommonResponse.ok("成功", ruleId);
    }

}
