package com.xforceplus.elephant.image.controller.batchnumberrule.process.autonomous;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BatchNumberRuleDefineDTO;
import com.xforceplus.elephant.image.client.model.GetSerialNumberRequest;
import com.xforceplus.elephant.image.controller.batchnumberrule.process.AbstractBatchNumberRuleProcess;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.validation.ValidationException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class GetNoRuleSerialNumberProcess extends AbstractBatchNumberRuleProcess<GetSerialNumberRequest, Map<String, String>> {

    @Override
    protected void check(GetSerialNumberRequest request) throws ValidationException {
        super.check(request);
    }

    @Override
    protected CommonResponse<Map<String, String>> process(GetSerialNumberRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }

        final Map<String, String> resultMap = new HashMap<>();

        final StringBuffer rulePre = new StringBuffer();
        final Integer[] length = {Optional.ofNullable(request.getLength()).orElse(0)};

        final BatchNumberRuleDefineDTO batchNumberRuleDefineDTO = new BatchNumberRuleDefineDTO();
        batchNumberRuleDefineDTO.setAutoIncrement(request.getAutoIncrementAble() == null ? "0" : request.getAutoIncrementAble().toString());
        batchNumberRuleDefineDTO.setLength(length);

        rulePre.append(request.getDate());
        //rulePre.append(batchNumberRuleDefineDTO.getAutoIncrement());
        //rulePre.append(batchNumberRuleDefineDTO.getLength());
        final String ruleCode = "NoRuleSerialNumber";

        final String serialNumber = batchNumberRuleFacade.selectNextSerialNumber(String.valueOf(authorizedUser.getTenantId()), ruleCode, rulePre.toString());

        // 补齐0
        final String newSerialNumber = appendSerialNumberPre(serialNumber, batchNumberRuleDefineDTO.getLength()[0]);

        //补齐日期
        //final String dateSerialNumber = String.format("%s%s", request.getDate(), newSerialNumber);

        resultMap.put("serialNumber", newSerialNumber);

        return CommonResponse.ok("成功", resultMap);
    }

}
