package com.xforceplus.elephant.image.controller.batchnumberrule.process.autonomous;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BatchNumberRuleDefineDTO;
import com.xforceplus.elephant.image.client.model.GetSerialNumberRequest;
import com.xforceplus.elephant.image.controller.batchnumberrule.process.AbstractBatchNumberRuleProcess;
import com.xforceplus.elephant.image.core.repository.model.BatchNumberRuleEntity;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.HashMap;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class GetSerialNumberProcess extends AbstractBatchNumberRuleProcess<GetSerialNumberRequest, Map<String, String>> {

    @Override
    protected void check(GetSerialNumberRequest request) throws ValidationException {
        super.check(request);
    }

    @Override
    protected CommonResponse<Map<String, String>> process(GetSerialNumberRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }

        final Map<String, String> resultMap = new HashMap<>();

        //校验放在此处，主要是序列号规则对象是一定要查询的，减少重复查询
        final BatchNumberRuleEntity batchNumberRuleEntity = getBatchNumberRule(request.getRuleCode(), authorizedUser.getTenantId());
        checkAvailable(batchNumberRuleEntity);

        final String ruleDefine = batchNumberRuleEntity.getRuleDefine();
        final StringBuffer rulePre = new StringBuffer();
        final BatchNumberRuleDefineDTO batchNumberRuleDefineDTO = analysisRuleDefine(request, ruleDefine, rulePre);
        String serialNumber = "0";
        if (batchNumberRuleDefineDTO.autoIncrementAble()) {
            serialNumber = batchNumberRuleFacade.selectNextSerialNumber(String.valueOf(authorizedUser.getTenantId()), request.getRuleCode(), rulePre.toString());
        } else {
            serialNumber = batchNumberRuleFacade.selectCurrentSerialNumber(String.valueOf(authorizedUser.getTenantId()), request.getRuleCode(), rulePre.toString());
        }

        resultMap.put("serialNumber", appendSerialNumberPre(serialNumber, batchNumberRuleDefineDTO.getLength()[0]));

        return CommonResponse.ok("成功", resultMap);
    }

}
