package com.xforceplus.elephant.image.controller.billdata;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.RedisLockMD5;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.BaseBillApi;
import com.xforceplus.elephant.image.client.model.BackBaseBillRequest;
import com.xforceplus.elephant.image.client.model.BaseBillCommitRequest;
import com.xforceplus.elephant.image.client.model.BaseBillDeleteRequest;
import com.xforceplus.elephant.image.client.model.BatchDownloadImageRequest;
import com.xforceplus.elephant.image.client.model.BillDetailBean;
import com.xforceplus.elephant.image.client.model.BillSummaryCount;
import com.xforceplus.elephant.image.client.model.DownloadImageRequest;
import com.xforceplus.elephant.image.client.model.GetBaseBillDetailRequest;
import com.xforceplus.elephant.image.client.model.GetBillTypeListRequest;
import com.xforceplus.elephant.image.client.model.GetCountInfoRequest;
import com.xforceplus.elephant.image.client.model.GetDetailResourceCodeRequest;
import com.xforceplus.elephant.image.client.model.GetListResourceCodeRequest;
import com.xforceplus.elephant.image.client.model.GetOrSaveBillRequest;
import com.xforceplus.elephant.image.client.model.HangBillRequest;
import com.xforceplus.elephant.image.client.model.HookTicketRequest;
import com.xforceplus.elephant.image.client.model.ReCheckBillRequest;
import com.xforceplus.elephant.image.client.model.RePushBillRequest;
import com.xforceplus.elephant.image.client.model.ReTransformBillsRequest;
import com.xforceplus.elephant.image.client.model.SplitBillRequest;
import com.xforceplus.elephant.image.client.model.UpdateVerifyStatusRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.billdata.process.BatchDownloadImageProcess;
import com.xforceplus.elephant.image.controller.billdata.process.DownloadBillImageProcess;
import com.xforceplus.elephant.image.controller.billdata.process.GetBillCodeProcess;
import com.xforceplus.elephant.image.controller.billdata.process.GetBillImageDetailProcess;
import com.xforceplus.elephant.image.controller.billdata.process.GetBillTypeListProcess;
import com.xforceplus.elephant.image.controller.billdata.process.GetDetailResourceCodeProcess;
import com.xforceplus.elephant.image.controller.billdata.process.GetListResourceCodeProcess;
import com.xforceplus.elephant.image.controller.billdata.process.GetOrSaveBillProcess;
import com.xforceplus.elephant.image.controller.billdata.process.GetOrgExtensionsProcess;
import com.xforceplus.elephant.image.controller.billdata.process.HangBillDataProcess;
import com.xforceplus.elephant.image.controller.billdata.process.OperationDeleteBillProcess;
import com.xforceplus.elephant.image.controller.billdata.process.PendingBackBaseBillProcess;
import com.xforceplus.elephant.image.controller.billdata.process.ReCheckBillProcess;
import com.xforceplus.elephant.image.controller.billdata.process.RePushBillProcess;
import com.xforceplus.elephant.image.controller.billdata.process.ReTransformBillsProcess;
import com.xforceplus.elephant.image.controller.billdata.process.SplitBillProcess;
import com.xforceplus.elephant.image.controller.billdata.process.UpdateBillVerifyStatusProcess;
import com.xforceplus.elephant.image.controller.billdata.process.billdetail.GetBillDataImageDetailProcess;
import com.xforceplus.elephant.image.controller.billdata.process.commit.BillDataCommitProcess;
import com.xforceplus.elephant.image.controller.billdata.process.countinfo.DefaultGetBillCountInfoProcess;
import com.xforceplus.elephant.image.controller.billdata.process.delete.DefaultDeleteBillDataProcess;
import com.xforceplus.elephant.image.controller.billdata.process.hookticket.DefaultHookTicketProcess;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class BaseBillController extends BaseController implements BaseBillApi {

    @Autowired
    private HangBillDataProcess hangBillDataProcess;
    @Autowired
    private UpdateBillVerifyStatusProcess updateBillVerifyStatusProcess;
    @Autowired
    private GetBillImageDetailProcess getBillImageDetailProcess;
    @Autowired
    private GetBillCodeProcess getBillCodeProcess;
    @Autowired
    private GetDetailResourceCodeProcess getDetailResourceCodeProcess;
    @Autowired
    private GetListResourceCodeProcess getListResourceCodeProcess;
    @Autowired
    private GetOrgExtensionsProcess getOrgExtensionsProcess;
    @Autowired
    private SplitBillProcess splitBillProcess;
    @Autowired
    private GetBillTypeListProcess getBillTypeListProcess;
    @Autowired
    private PendingBackBaseBillProcess pendingBackBaseBillProcess;
    @Autowired
    private BatchDownloadImageProcess batchDownloadImageProcess;
    @Autowired
    private DownloadBillImageProcess downloadBillImageProcess;
    @Autowired
    private ReCheckBillProcess reCheckBillProcess;
    @Autowired
    private GetOrSaveBillProcess getOrSaveBillProcess;
    @Autowired
    private RePushBillProcess rePushBillProcess;
    @Autowired
    private OperationDeleteBillProcess operationDeleteBillProcess;
    @Autowired
    private ReTransformBillsProcess reTransformBillsProcess;

    @Override
    public CommonResponse<BillDetailBean> getBaseBillDetail(GetBaseBillDetailRequest request) {
        return process(GetBillDataImageDetailProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse<JSONObject> commit(@RequestBody BaseBillCommitRequest request) {
        return process(BillDataCommitProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse delete(@RequestBody BaseBillDeleteRequest request) {
        return process(DefaultDeleteBillDataProcess.class).execute(request);
    }

    @Override
    public CommonResponse<BillSummaryCount> getCountInfo(GetCountInfoRequest request) {
        return process(DefaultGetBillCountInfoProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse<Integer> hangBill(@RequestBody HangBillRequest request) {
        return hangBillDataProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse hookTicket(@RequestBody HookTicketRequest request) {
        return process(DefaultHookTicketProcess.class).execute(request);
    }

    @Override
    public CommonResponse orgExtensions(BaseRequest request) {
        return getOrgExtensionsProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse updateVerifyStatus(@RequestBody UpdateVerifyStatusRequest request) {
        return updateBillVerifyStatusProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse pendingBackBaseBill(@RequestBody BackBaseBillRequest request) {
        return pendingBackBaseBillProcess.execute(request);
    }

    @RequestMapping(method = RequestMethod.GET, value = "/baseBill/getBillImageDetail/{keyCode}")
    @AuthorizedDefinition(authorization = false)
    public String getBillImageDetail(@PathVariable String keyCode, HttpServletRequest req, HttpServletResponse resp) {
        final String url = getBillImageDetailProcess.process(keyCode);
        if (StringHelp.safeIsEmpty(url)) {
            throw new ElephantException("影像地址无效.");
        }
        final String html = HttpUtils.doGet(url);
        return html.replaceAll("[.]/", "/");
    }

    @Override
    public CommonResponse getBillCode(@PathVariable String keyCode, @Valid BaseRequest request) {
        return getBillCodeProcess.execute(keyCode, request);
    }

    @Override
    public CommonResponse getBillTypeList(GetBillTypeListRequest request) {
        return getBillTypeListProcess.execute(request);
    }

    @Override
    public CommonResponse getDetailResourceCode(@Valid GetDetailResourceCodeRequest request) {
        return getDetailResourceCodeProcess.execute(request);
    }

    @Override
    public CommonResponse getListResourceCode(@Valid GetListResourceCodeRequest request) {
        return getListResourceCodeProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse split(@RequestBody SplitBillRequest request) {
        return splitBillProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse downloadImageByBillNo(@RequestBody BatchDownloadImageRequest request) {
        return batchDownloadImageProcess.execute(request);
    }

    //@RedisLockMD5()
    @Override
    public CommonResponse downloadImage(@RequestBody DownloadImageRequest request) {
        return downloadBillImageProcess.execute(request);
    }

    @Override
    public CommonResponse reCheckBill(@RequestBody ReCheckBillRequest request) {
        return reCheckBillProcess.execute(request);
    }

    @ApiOperation("查询或创建单据")
    @PostMapping("/baseBill/getOrSaveBill")
    public CommonResponse<Map<String, Object>> getOrSaveBill(@RequestBody GetOrSaveBillRequest request) {
        return getOrSaveBillProcess.execute(request);
    }

    @ApiOperation("重新下发单据")
    @PostMapping("/baseBill/rePushBill")
    public CommonResponse<Boolean> rePushBill(@RequestBody RePushBillRequest request) {
        return rePushBillProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse operationDelete(@RequestBody BaseBillDeleteRequest request) {
        return operationDeleteBillProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("失败文件重新发起转换")
    @PostMapping("/baseBill/reTransformBills")
    public CommonResponse<Boolean> reTransformBills(@RequestBody ReTransformBillsRequest request) {
        return reTransformBillsProcess.execute(request);
    }

}