package com.xforceplus.elephant.image.controller.billdata.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.RedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GetBillImageDetailProcess {

    @Autowired
    private RedisUtils redisUtils;

    @Value("${openapi.image.redirectUrl:''}")
    private String redirectUrl;

    public String process(String keyCode) {
        if (!redisUtils.hasKey(keyCode)) {

            return null;
        }
        final String result = (String) redisUtils.get(keyCode);
        if (null != result) {
            final JSONObject jsonObject = JSONObject.parseObject(result);
            if (jsonObject.containsKey("billCode") && jsonObject.get("billCode") != null) {
                return redirectUrl + "&billCode=" + jsonObject.get("billCode").toString();
            }
        }
        return null;
    }

}
