package com.xforceplus.elephant.image.controller.billdata.process;

import com.xforceplus.elephant.basecommon.enums.EntityConstant;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetBillTypeListRequest;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.metadata.domain.vo.dto.UltPageBoItem;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetBillTypeListProcess extends AbstractProcess<GetBillTypeListRequest, List<UltPageBoItem>> {

    @Autowired
    private BaseBillService baseBillService;

    @Override
    protected void check(GetBillTypeListRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getPageCode())) {
            throw new ValidationException("页面code【pageCode】不能为空");
        }
    }

    @Override
    protected CommonResponse<List<UltPageBoItem>> process(GetBillTypeListRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        final List<UltPageBoItem> ultPageBoItems = baseBillService.getUltPageBoItemList(authorizedUser.getTenantId(), authorizedUser.getTenantCode(), request.getPageCode())
            .stream().filter(r -> !EntityConstant.BASE_BILL.equals(r.getBoCode()))
            .collect(Collectors.toList());
        return CommonResponse.ok("成功", ultPageBoItems);
    }

}