package com.xforceplus.elephant.image.controller.billdata.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetOrSaveBillRequest;
import com.xforceplus.elephant.image.core.business.application.config.common.enums.ReceiveFilterEnums;
import com.xforceplus.elephant.image.core.business.util.PlainEntityServiceWrapper;
import com.xforceplus.elephant.image.core.facade.application.config.dictionary.extfields.ExtFieldsReceiveFacade;
import com.xforceplus.elephant.image.core.facade.base.BaseFacade;
import com.xforceplus.elephant.image.core.util.RequestBuilder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CalculateStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.IsPublic;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * 获取或创建单据
 *
 * @author liuhongbin
 * @date 2021/7/26 16:33
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class GetOrSaveBillProcess extends AbstractProcess<GetOrSaveBillRequest, Map<String, Object>> {

    private final BaseFacade baseFacade;
    private final PlainEntityServiceWrapper entityServiceWrapper;
    private final ExtFieldsReceiveFacade extFieldsReceiveFacade;

    @Override
    protected void check(GetOrSaveBillRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCode(), "单据号不能为空");
        checkEmpty(request.getBillTypeCode(), "单据类型不能为空");
        if (entityServiceWrapper.loadByCode(request.getBillTypeCode()) == null) {
            throw new ValidationException("单据类型不存在!");
        }
    }

    @Override
    protected CommonResponse<Map<String, Object>> process(GetOrSaveBillRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final ConditionQueryRequest queryRequest = new RequestBuilder()
            .field(EntityMeta.BaseBill.TENANT_ID.code(), ConditionOp.eq, user.getTenantId())
            .field(EntityMeta.BaseBill.BILL_CODE.code(), ConditionOp.eq, request.getBillCode())
            .pageSize(1)
            .build();
        final boolean isCompare = StringUtils.startsWith(request.getBillTypeCode(), "compare");
        final String billBoCode = isCompare ? EntityMeta.CompareBaseBill.code() : EntityMeta.BaseBill.code();
        final DataCollection<Map<String, Object>> mapDataCollection = baseFacade.findByCondition(billBoCode, queryRequest);
        if (mapDataCollection.getRowNum() == 0 && !request.isCreated()) {
            return CommonResponse.ok("未查询到单据：" + request.getBillCode());
        }
        if (mapDataCollection.getRowNum() > 0) {
            return CommonResponse.ok("单据已存在", mapDataCollection.getRows().get(0));
        }
        final JSONObject bill = new JSONObject();
        bill.put(EntityMeta.BaseBill.BILL_CODE.code(), request.getBillCode());
        bill.put(EntityMeta.BaseBill.BILL_TYPE_CODE.code(), request.getBillTypeCode());
        //JXCPX-813 调用创建单据接口时，创建成功，但单据一直在计算中，期望：显示计算完成
        bill.put(EntityMeta.BaseBill.CALCULATE_STATUS.code(), CalculateStatus._1.getCode());
        //JXCPX-880 通过影像调阅页创建的单据，单据内直接上传发票，显示在了个人单证池的未提交
        bill.put(EntityMeta.BaseBill.IS_PUBLIC.code(), IsPublic._2.getCode());
        if (ValidatorUtil.isNotEmpty(request.getExt())) {
            bill.putAll(extFieldsReceiveFacade.getExtFields(user.getTenantId(), ReceiveFilterEnums.BILL, request.getExt()));
        }
        bill.put(EntityMeta.BaseBill.CREATE_USER_CODE.code(), user.getUserCode());
        bill.put(EntityMeta.BaseBill.BILL_CREATE_USER.code(), user.getUserName());
        bill.put(EntityMeta.BaseBill.BILL_CREATE_TIME.code(), System.currentTimeMillis());
        final Long id = baseFacade.create(request.getBillTypeCode(), bill);
        final Map<String, Object> entity = baseFacade.findOne(request.getBillTypeCode(), id);
        return CommonResponse.ok("单据创建成功", entity);
    }

}
