package com.xforceplus.elephant.image.controller.billdata.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.HangBillRequest;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.facade.application.calculate.commit.BillCommitFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class HangBillDataProcess extends AbstractProcess<HangBillRequest, Integer> {

    private final BaseBillService baseBillService;
    private final BillCommitFacade billCommitFacade;

    @Override
    protected void check(HangBillRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "billCodes不能为空!");
    }

    @Override
    protected CommonResponse<Integer> process(HangBillRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();// 获取登录用户上下文
        if (null == user) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }

        final int count = baseBillService.hangBill(user.getTenantId(), request.getBillCodes(), request.getHangType(), request.getHangReason());
        //如果有稽核单据，更新稽核单据的主单据状态
        request.getBillCodes().forEach(billCode -> billCommitFacade.updateCompareBill(user.getTenantId(), billCode, BillDataStatus._2.getCode()));
        return CommonResponse.ok("成功", count);
    }

}
