package com.xforceplus.elephant.image.controller.billdata.process;

import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BaseBillDeleteRequest;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.operationlog.OperationLogService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationEntity;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 运维单据删除
 * @author rongying
 * @date 2021/12/31 14:06
 */
@Service
public class OperationDeleteBillProcess extends AbstractProcess<BaseBillDeleteRequest, Boolean> {

    @Autowired
    private BillImageTicketService billImageTicketService;
    @Autowired
    private BaseBillService baseBillService;
    @Autowired
    private ImageService imageService;
    @Autowired
    private TicketFacade ticketFacade;
    @Autowired
    private OperationLogService operationLogService;

    @Override
    protected void check(BaseBillDeleteRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "billCodes不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(BaseBillDeleteRequest request) throws RuntimeException {
        // 获取登录用户上下文
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final List<BaseBill> billEntityList = baseBillService.selectBillDataByBillCodes(authorizedUser.getTenantId(), request.getBillCodes());
        if (ValidatorUtil.isEmpty(billEntityList)) {
            return CommonResponse.failed("无记录删除");
        }
        final List<String> deleteBillCodes = billEntityList.stream().map(r -> r.getBillCode()).collect(Collectors.toList());
        //查询影像
        final List<Long> imageIds = imageService.selectImageIdsByBillCodes(authorizedUser.getTenantId(), deleteBillCodes);
        //查询单证
        final List<Ticket> ticketList = ticketFacade.selectBaseTicketByImageIds(authorizedUser.getTenantId(), imageIds, EntityMeta.Ticket.code());
        //删除影像单证
        boolean result = billImageTicketService.deleteImageAndTicketByImageIds(authorizedUser.getTenantId(), imageIds);
        //删除单据
        result = baseBillService.deleteListBillData(authorizedUser.getTenantId(), deleteBillCodes) > 0 && result;
        if (!result) {
            return CommonResponse.failed("删除失败");
        }
        //记录运维日志
        ticketList.forEach(r -> operationLogService.insertOperationLog(OperationEntity.TICKET.getCode(), StringHelp.safeToString(r.getId()), OperationType.DELETE_TICKET.getCode(),
            authorizedUser.getUsername(), String.format("整单删除单据号:%s", r.getBillCode())));
        deleteBillCodes.forEach(r -> operationLogService.insertOperationLog(OperationEntity.BILL.getCode(), r, OperationType.DELETE_BILL.getCode(),
            authorizedUser.getUsername(), ""));
        return CommonResponse.ok("删除成功", true);
    }

}