package com.xforceplus.elephant.image.controller.billdata.process;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.RePushBillRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.common.TicketSupport;
import com.xforceplus.elephant.image.core.domain.operationlog.OperationLogService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CalculateStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationEntity;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import java.util.HashMap;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@RequiredArgsConstructor
@Service
public class RePushBillProcess extends AbstractProcess<RePushBillRequest, Boolean> {

    private final BaseBillService baseBillService;
    private final MQUtils rabbitmqUtils;
    private final OperationLogService operationLogService;
    private final TicketSupport ticketSupport;

    @Override
    protected void check(RePushBillRequest request) throws ValidationException {
        checkEmpty(request.getBillCode(), "billCodes不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(RePushBillRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();

        final BaseBill billEntity = baseBillService.selectBaseBillByCode(user.getTenantId(), request.getBillCode());
        checkEmpty(billEntity, "单据不存在");
        if (BillDataStatus._0.getCode().equals(billEntity.getBillDataStatus())) {
            return CommonResponse.failed("单据未提交不可下发");
        }
        if (!CalculateStatus._1.getCode().equals(billEntity.getCalculateStatus())) {
            return CommonResponse.failed("单据计算中不可下发");
        }
        if (YesNo._1.getCode().equals(billEntity.getIsException())) {
            return CommonResponse.failed("单据异常不可下发");
        }
        final String rateKey = String.format("RESENDBILL:%s:%s", user.getTenantId(), request.getBillCode());
        if (!ticketSupport.acquireByLimiter(rateKey)) {
            return CommonResponse.failed("请求速率过快！请稍后重试!");
        }

        final Map<String, Object> pushMap = Maps.newHashMap();
        pushMap.put("source", "下发单据");
        pushMap.put("tenantId", user.getTenantId());
        pushMap.put("billCode", billEntity.getBillCode());
        pushMap.put("billTypeCode", billEntity.getBillTypeCode());
        final Map<String, Object> headers = new HashMap<>();
        headers.put(TENANT_CODE, user.getTenantCode());
        rabbitmqUtils.sendByDirectExchange(MQEnum.SYNC_BILL_TICKET_QUEUE, pushMap, headers);
        operationLogService.insertOperationLog(OperationEntity.BILL.getCode(), request.getBillCode(),
            OperationType.PUSH_BILL.getCode(), user.getUsername(), "");
        return CommonResponse.ok("发起下发成功，请稍后确认");
    }

}
