package com.xforceplus.elephant.image.controller.billdata.process;

import com.xforceplus.elephant.basecommon.enums.bill.VerifyStatusEnum;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.UpdateVerifyStatusRequest;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateBillVerifyStatusProcess extends AbstractProcess<UpdateVerifyStatusRequest, Boolean> {

    @Autowired
    private BaseBillService baseBillService;

    @Override
    protected void check(UpdateVerifyStatusRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "billCode不能为空");
        checkEmpty(request.getVerifyStatus(), "核验签收状态不能为空");
        if (VerifyStatusEnum.VERIFY_UN_QUALIFY.getCode().equals(request.getVerifyStatus())) {
            checkEmpty(request.getUnqualityType(), "不合格原因类型不能为空");
        }
        if (VerifyStatusEnum.PENDING_HANG.getCode().equals(request.getVerifyStatus())) {
            checkEmpty(request.getVerfiyHangType(), "暂挂起原因类型不能为空");
        }
        checkEmpty(VerifyStatusEnum.fromCode(request.getVerifyStatus()), "核验签收状态有误！");
    }

    @Override
    protected CommonResponse<Boolean> process(UpdateVerifyStatusRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        switch (VerifyStatusEnum.fromCode(request.getVerifyStatus())) {
            case PENDING_HANG:
                baseBillService.updateVerifyStatus(authorizedUser.getTenantId(), request.getBillCodes(), request.getVerifyStatus(), request.getVerfiyHangType(), request.getVerfiyHangReason());
                break;

            case VERIFY_UN_QUALIFY:
                baseBillService.updateVerifyStatus(authorizedUser.getTenantId(), request.getBillCodes(), request.getVerifyStatus(), request.getUnqualityType(), request.getUnqualityReason());
                break;
            case VERIFY_QUALIFY:
                baseBillService.updateVerifyStatus(authorizedUser.getTenantId(), request.getBillCodes(), request.getVerifyStatus(), null, null);
                break;
            default:
                break;
        }
        return CommonResponse.ok("成功", true);
    }

}
