package com.xforceplus.elephant.image.controller.billdata.process.commit;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.dispatch.BeanDispatcher;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BaseBillCommitRequest;
import com.xforceplus.elephant.image.client.model.EntityObj;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.collaboration.CooperationService;
import com.xforceplus.elephant.image.core.expand.impl.billimageticket.DefaultBillImageTicketServiceImpl;
import com.xforceplus.elephant.image.core.facade.dto.commit.BillCommitFailDto;
import com.xforceplus.elephant.image.core.util.BusinessLogMqUtils;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(tenantCode = "CQP")
@Service
public class CQPBillDataCommitProcess extends BillDataCommitProcess {

    @Autowired
    private BaseBillService baseBillService;

    @Autowired
    private CooperationService cooperationService;

    @Autowired
    private MQUtils rabbitmqUtils;

    @Autowired
    private BeanDispatcher beanDispatcher;

    @Autowired
    private BusinessLogMqUtils businessLogMqUtils;

    @Override
    protected void check(BaseBillCommitRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getEntities(), "entities不能为空");
    }

    @Override
    protected CommonResponse<JSONObject> process(BaseBillCommitRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final List<String> billCodes = request.getEntities().stream().map(EntityObj::getBillCode).collect(Collectors.toList());
        final List<String> commitBillCodes = Lists.newArrayList();
        Set<BillCommitFailDto> failDtoList = new LinkedHashSet<>();
        final StringBuilder message = new StringBuilder();
        for (String billCode : billCodes) {
            final Tuple2<Boolean, String> commitStatus = beanDispatcher.dispatch(authorizedUser.getTenantId(), DefaultBillImageTicketServiceImpl.class)
                                                                       .checkCommit(authorizedUser.getTenantId(), billCode);
            if (commitStatus._1) {
                commitBillCodes.add(billCode);
            } else {
                message.append(commitStatus._2 + "\n");
                failDtoList.add(new BillCommitFailDto(billCode, message.toString()));
            }
        }

        final Tuple2<Integer, Set<BillCommitFailDto>> tuple2 = defaultCommit(authorizedUser.getTenantId(), authorizedUser.getTenantCode(), commitBillCodes, failDtoList);
        final int count = tuple2._1;
        failDtoList = tuple2._2;

        final JSONObject result = new JSONObject();
        result.put("selectedCount", billCodes.size());
        result.put("successfulCount", count);
        result.put("failedCount", billCodes.size() - count);
        result.put("calculateCount", billCodes.size() - commitBillCodes.size());
        result.put("message", message.toString());
        result.put("failDtoList", failDtoList);
        return CommonResponse.ok("成功", result);
    }

    private Tuple2<Integer, Set<BillCommitFailDto>> defaultCommit(Long tenantId, String tenantCode, List<String> billCodes, Set<BillCommitFailDto> failDtoList) {
        if (ValidatorUtil.isEmpty(billCodes)) {
            return Tuple.of(0, failDtoList);
        }
        final List<Long> updateIds = Lists.newArrayList();
        final List<BaseBill> list = baseBillService.selectBillDataByBillCodes(tenantId, billCodes);
        list.stream().forEach(dataEntity -> {
            if (dataEntity.getImageId() == 0) {
                failDtoList.add(new BillCommitFailDto(dataEntity.getBillCode(), "未补扫封面"));
                return;
            }
            if (YesNo._0.getCode().equals(dataEntity.getIsException()) || Long.valueOf(0).equals(dataEntity.getExceptionCount()) || null == dataEntity.getExceptionCount()) {
                updateIds.add(dataEntity.getId());
                businessLogMqUtils.addBillLog(tenantId, dataEntity.getId(), dataEntity.getBillCode(), dataEntity.getBillDataStatus(), BillDataStatus._3.getCode(),
                    "提交", null);
            } else {
                failDtoList.add(new BillCommitFailDto(dataEntity.getBillCode(), dataEntity.getBillCode() + "存在异常,不可提交"));
            }
        });
        int count = 0;
        final JSONObject update = new JSONObject();
        final long currentTime = System.currentTimeMillis();
        update.put("bill_data_status", BillDataStatus._3.getCode());
        update.put("bill_data_time", currentTime);
        update.put("is_push_bill", YesNo._0.getCode());
        update.put("is_cover", YesNo._0.getCode());
        for (Long id : updateIds) {
            count = count + baseBillService.updateByBillIdSelective(id, update);
        }

        list.stream().filter(r -> updateIds.contains(r.getId())).forEach(baseBill -> {
            cooperationService.reCheckBillTicketAsync(tenantId, tenantCode, baseBill.getBillTypeCode(), baseBill.getBillCode(), "service-单据提交");
        });
        return Tuple.of(count, failDtoList);
    }

}
