package com.xforceplus.elephant.image.controller.billdata.process.delete;

import com.alibaba.fastjson.JSONObject;
import com.google.api.client.util.Lists;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BaseBillDeleteRequest;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(tenantCode = "CQP")
@Service
public class CQPDeleteBillDataProcess extends DefaultDeleteBillDataProcess {

    @Autowired
    private BillImageTicketService billImageTicketService;
    @Autowired
    private BaseBillService baseBillService;
    @Autowired
    private ImageService imageService;

    @Override
    protected void check(BaseBillDeleteRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "billCodes不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(BaseBillDeleteRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final List<BaseBill> billEntityList = baseBillService.selectBillDataByBillCodes(authorizedUser.getTenantId(), request.getBillCodes());
        if (ValidatorUtil.isEmpty(billEntityList)) {
            return CommonResponse.failed("无记录删除");
        }
        final List<String> cantDeletedBillCodes = Lists.newArrayList();

        final List<String> deleteBillCodes = billEntityList.stream()
            .filter(bill -> BillDataStatus._0.getCode().equals(bill.getBillDataStatus())
                || BillDataStatus._2.getCode().equals(bill.getBillDataStatus()))
            .map(BaseBill::getBillCode)
            .collect(Collectors.toList());
        if (ValidatorUtil.isEmpty(deleteBillCodes)) {
            return CommonResponse.failed("勾选单据状态不是待提交或暂挂起，拒绝删除");
        }
        //JXCPX-1935 可删除识别中、转化中数据
        /*deleteBillCodes.forEach(billCode -> {
            final Integer noFinishRecCount = imageService.noFinishRecImageCount(authorizedUser.getTenantId(), billCode);
            if (noFinishRecCount > 0) {
                cantDeletedBillCodes.add(billCode);
                return;
            }
        });
        if (ValidatorUtil.isNotEmpty(cantDeletedBillCodes)) {
            return CommonResponse.failed("未识别计算完成不可删除，拒绝删除");
        }*/
        final List<Long> imageIds = imageService.selectImageIdsByBillCodes(authorizedUser.getTenantId(), deleteBillCodes);
        billImageTicketService.deleteImageAndTicketByImageIds(authorizedUser.getTenantId(), imageIds);
        final List<Long> billDataIds = baseBillService.selectBillIdByBillCode(authorizedUser.getTenantId(), deleteBillCodes);
        final JSONObject update = new JSONObject();
        update.put("is_push_bill", YesNo._1.getCode());
        update.put("image_id", 0L);
        billDataIds.forEach(billId -> baseBillService.updateByBillIdSelective(billId, update));

        return CommonResponse.ok("删除成功");
    }

}