package com.xforceplus.elephant.image.controller.common;

import static com.xforceplus.elephant.image.core.business.consts.Constants.IMAGE_PREFIX;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.CommonApi;
import com.xforceplus.elephant.image.client.model.CollectErrorsRequest;
import com.xforceplus.elephant.image.client.model.ConfigSettingRequest;
import com.xforceplus.elephant.image.client.model.EntityFieldDTO;
import com.xforceplus.elephant.image.client.model.MobileUploadHandleRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.common.process.DownloadProcess;
import com.xforceplus.elephant.image.controller.common.process.GetConfigMenuProcess;
import com.xforceplus.elephant.image.controller.common.process.GetConfigSettingProcess;
import com.xforceplus.elephant.image.controller.common.process.GetEntityChildrenProcess;
import com.xforceplus.elephant.image.controller.common.process.GetEntityFieldsProcess;
import com.xforceplus.elephant.image.controller.common.process.GetFieldsProcess;
import com.xforceplus.elephant.image.controller.common.process.GetSettingsProcess;
import com.xforceplus.elephant.image.controller.common.process.GetUserDepartmentProcess;
import com.xforceplus.elephant.image.controller.common.process.MobileUploadHandleProcess;
import com.xforceplus.elephant.image.controller.common.process.SaveConfigSettingProcess;
import com.xforceplus.elephant.image.controller.common.process.VersionProcess;
import com.xforceplus.general.core.collect.annotation.Collect;
import com.xforceplus.general.core.collect.enums.EventSimpleName;
import com.xforceplus.general.core.collect.support.CollectHolder;
import com.xforceplus.general.utils.enums.AppInfoEnum;
import com.xforceplus.general.utils.enums.StatusEnum;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@ApiV1Image
public class CommonController extends BaseController implements CommonApi {

    @Autowired
    private GetEntityFieldsProcess getEntityFieldsProcess;
    @Autowired
    private GetEntityChildrenProcess getEntityChildrenProcess;
    @Autowired
    private GetSettingsProcess getSettingsProcess;
    @Autowired
    private GetUserDepartmentProcess getUserDepartmentProcess;
    @Autowired
    private DownloadProcess downloadProcess;
    @Autowired
    private MobileUploadHandleProcess mobileUploadHandleProcess;
    @Autowired
    private GetConfigMenuProcess getConfigMenuProcess;
    @Autowired
    private GetConfigSettingProcess getConfigSettingProcess;
    @Autowired
    private SaveConfigSettingProcess saveConfigSettingProcess;
    @Autowired
    private GetFieldsProcess getFieldsProcess;
    @Autowired
    private VersionProcess versionProcess;

    @Override
    public CommonResponse getEntityChildren(@PathVariable final Integer configDataMappingType, final BaseRequest request) {
        return getEntityChildrenProcess.execute(configDataMappingType, request);
    }

    @Override
    public CommonResponse<List<String>> getEntityFields(@PathVariable final String entityCode, final BaseRequest request) {
        return getEntityFieldsProcess.execute(entityCode, request);
    }

    @Override
    public CommonResponse<IAuthorizedUser> getUserInfo(final BaseRequest request) {
        return CommonResponse.ok("成功", UserInfoHolder.get());
    }

    @Override
    public CommonResponse<JSONObject> settings(final BaseRequest request) {
        return getSettingsProcess.execute(request);
    }

    @Override
    public CommonResponse<JSONArray> userDepartment(@Valid final BaseRequest request) {
        return getUserDepartmentProcess.execute(request);
    }

    @GetMapping("/common/download")
    public ResponseEntity<StreamingResponseBody> download(@RequestParam final String fileName, @RequestParam final String key) {
        return downloadProcess.execute(fileName, key);
    }

    @Override
    public CommonResponse mobileUploadHandle(@RequestBody final MobileUploadHandleRequest request) {
        return mobileUploadHandleProcess.execute(request);
    }

    @Caching(evict = {
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:select"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:selectOne"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:selectDefault"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:selectClass"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings:selectClassDefault"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configSettings"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDictionary:select"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDictionary:selectItems"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDictionary:selectItem"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDict"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDict:json"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDict:T"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDict:map"}, allEntries = true),
        @CacheEvict(cacheNames = {IMAGE_PREFIX + "configDictObj:T"}, allEntries = true),
    })
    @Override
    public CommonResponse saveConfig(final String code, final JSONObject data) {
        return saveConfigSettingProcess.execute(new ConfigSettingRequest(code, data));
    }

    @Override
    public CommonResponse getConfigMenu() {
        return getConfigMenuProcess.execute(new BaseRequest());
    }

    @Override
    public CommonResponse getConfig(@PathVariable("code") final String code) {
        final BaseRequest request = new BaseRequest();
        request.setRid(code);
        return getConfigSettingProcess.execute(request);
    }

    @Collect(eventName = EventSimpleName.FORE_GROUND, appInfo = AppInfoEnum.IMAGE_SERVICE)
    @Override
    public CommonResponse addErrors(@RequestBody final CollectErrorsRequest request) {
        CollectHolder.put(CollectHolder.get().channel(request.getPageCode()).addErrors(request.getErrors()).status(StatusEnum.SUCCESS));
        return CommonResponse.ok("接收成功");
    }

    @ApiOperation(value = "获取对象字段")
    @RequestMapping(value = "/common/fields/{entityCode}", produces = {"application/json"}, method = RequestMethod.GET)
    public CommonResponse<List<EntityFieldDTO>> getFields(@ApiParam(value = "对象CODE", required = true) @PathVariable("entityCode") String entityCode) {
        return getFieldsProcess.execute(entityCode);
    }

    @ApiOperation(value = "获取当前租户使用版本")
    @GetMapping(value = "/common/use20")
    public CommonResponse<Boolean> verson(@RequestParam(value = "keyCode", required = false) final String keyCode) {
        return versionProcess.execute(keyCode);
    }

}
