package com.xforceplus.elephant.image.controller.common.process;

import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.help.RedisUtils;
import com.xforceplus.elephant.basecommon.vaildate.Validator;
import com.xforceplus.elephant.image.core.business.infrastructure.port.FileService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Service
public class DownloadProcess implements Validator {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private FileService fileService;
    @Autowired
    private RedisUtils redisUtils;

    public ResponseEntity<StreamingResponseBody> execute(String fileName, String key) throws RuntimeException {
        checkEmpty(fileName, "文件不存在");
        checkEmpty(key, "文件不存在");
        String encodedName = fileName;
        InputStream input = null;
        final IAuthorizedUser user = UserInfoHolder.get();// 获取登录用户上下文
        if (null == user) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        try {
            encodedName = URLEncoder.encode(fileName, "UTF-8");
            if (key.startsWith("http")) {
                input = HttpUtils.doGetInputStream(key);
            } else {
                input = fileService.getFileInputStream(user.getTenantId(), user.getId(), key);
            }
            final InputStream finalInput = input;
            final StreamingResponseBody responseBody = outputStream -> {
                StreamUtils.copy(finalInput, outputStream);
                outputStream.close();
            };
            return ResponseEntity.ok()
                .header("Content-Disposition", "attachment;fileName=" + encodedName)
                .contentType(fileService.mediaType(fileName.substring(fileName.lastIndexOf(".") + 1)))
                .body(responseBody);
        } catch (Exception e) {
            logger.error("下载失败", e);
        }
        return ResponseEntity.notFound().build();
    }

}
