package com.xforceplus.elephant.image.controller.common.process;

import com.xforceplus.elephant.basecommon.enums.EntityConstant;
import com.xforceplus.elephant.basecommon.enums.config.ConfigDataMappingTypeEnum;
import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.business.util.PlainEntityServiceWrapper;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetEntityChildrenProcess extends AbstractKeyProcess<Integer, BaseRequest, List<String>> {

    @Autowired
    private PlainEntityServiceWrapper entityService;

    @Override
    protected CommonResponse<List<String>> process(Integer configDataMappingType, BaseRequest request) throws RuntimeException {
        final ConfigDataMappingTypeEnum configDataMappingTypeEnum =
            ConfigDataMappingTypeEnum.fromCode(configDataMappingType);
        if (configDataMappingTypeEnum == null
            || configDataMappingTypeEnum.getEntityCode() == null) {
            return CommonResponse.failed("不存在的模板分类");
        }
        final String entityCode = configDataMappingTypeEnum == ConfigDataMappingTypeEnum.ATTACHMENT ? EntityConstant.TICKET : configDataMappingTypeEnum.getEntityCode();
        final Collection<IEntityClass> entityClasses = entityService.loadByCode(entityCode).childEntityClasses();
        final List<String> entityCodes = entityClasses.stream()
            .map(entityClass -> entityClass.code())
            .collect(Collectors.toList());
        if (entityCodes.isEmpty()) {
            entityCodes.add(entityCode);
        }
        return CommonResponse.ok("成功", entityCodes);
    }

}
