package com.xforceplus.elephant.image.controller.common.process;

import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.business.util.PlainEntityServiceWrapper;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetEntityFieldsProcess extends AbstractKeyProcess<String, BaseRequest, List<String>> {

    @Autowired
    private PlainEntityServiceWrapper entityService;

    @Override
    protected CommonResponse<List<String>> process(String entityCode, BaseRequest request) throws RuntimeException {
        final IEntityClass entityClass = entityService.loadByCode(entityCode);
        if (entityClass == null) {
            return CommonResponse.failed("不存在此对象");
        }
        final List<String> fieldNames = entityClass.fields().stream()
            .map(field -> field.name())
            .collect(Collectors.toList());
        if (entityClass.extendEntityClass() != null) {
            fieldNames.addAll(entityClass.extendEntityClass().fields().stream()
                .map(field -> field.name()).collect(Collectors.toList()));
        }
        return CommonResponse.ok("成功", fieldNames);
    }

}
