package com.xforceplus.elephant.image.controller.common.process;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.EntityFieldDTO;
import com.xforceplus.elephant.image.mapper.FieldMapper;
import com.xforceplus.general.ultraman.store.UltramanDataStoreFacadeWrapper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class GetFieldsProcess {

    private final UltramanDataStoreFacadeWrapper ultramanDataStoreFacadeWrapper;
    private final FieldMapper fieldMapper;

    public CommonResponse<List<EntityFieldDTO>> execute(final String entityCode) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final IEntityClass entityClass = ultramanDataStoreFacadeWrapper.load(entityCode, user.getTenantCode());
        if (entityClass == null) {
            return CommonResponse.failed("不存在此对象");
        }
        final Collection<IEntityField> entityFields = entityClass.fields();
        if (entityClass.extendEntityClass() != null) {
            entityFields.addAll(entityClass.extendEntityClass().fields());
        }
        final List<EntityFieldDTO> fields = fieldMapper.mapper(new ArrayList<>(entityFields));
        return CommonResponse.ok("成功", fields);
    }

}
