package com.xforceplus.elephant.image.controller.common.process;

import com.xforceplus.elephant.basecommon.help.RedisUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.business.application.config.common.domain.WatermarkConfig;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 获取水印信息process
 *
 * @author liming
 * @date 2021/3/29 15:32
 */

@Service
public class GetWaterMarkProcess extends AbstractProcess<BaseRequest, WatermarkConfig> {

    @Autowired
    private RedisUtils redisUtils;
    @Resource
    private HttpServletRequest servletRequest;

    @Override
    protected CommonResponse<WatermarkConfig> process(final BaseRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        if (null == user) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        return CommonResponse.ok("成功");

    }

}
