package com.xforceplus.elephant.image.controller.common.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.RedisUtils;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.general.core.switchs.SwitchService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Slf4j
@Service
@RequiredArgsConstructor
public class VersionProcess {

    public static final String USE_20_ENABLE = "image-v2";

    private final RedisUtils redisUtils;
    private final SwitchService switchService;

    public CommonResponse<Boolean> execute(final String keyCode) throws RuntimeException {
        final String tenantCode;
        if (StringUtils.isNotBlank(keyCode)) {
            final String result = (String) redisUtils.get(keyCode);
            final JSONObject obj = JSON.parseObject(result);
            if (obj == null) {
                throw new ValidationException("调阅凭证已过期，请重新申请");
            }
            tenantCode = obj.getString("tenantCode");
        } else {
            final IAuthorizedUser user = UserInfoHolder.get();
            if (user == null) {
                throw new ValidationException("获取用户信息为空，请重新登陆");
            }
            tenantCode = user.getTenantCode();
        }
        final boolean use20 = switchService.open(USE_20_ENABLE, tenantCode, "");
        return CommonResponse.ok("成功", use20);
    }

}
