package com.xforceplus.elephant.image.controller.compare.billdata;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.RedisLockMD5;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.compare.CompareBaseBillApi;
import com.xforceplus.elephant.image.client.model.BackBaseBillRequest;
import com.xforceplus.elephant.image.client.model.BackBillDeleteRequest;
import com.xforceplus.elephant.image.client.model.BackCompareBillRequest;
import com.xforceplus.elephant.image.client.model.BaseBillCommitRequest;
import com.xforceplus.elephant.image.client.model.BaseBillDeleteRequest;
import com.xforceplus.elephant.image.client.model.BatchAuditBillRequest;
import com.xforceplus.elephant.image.client.model.BatchDownloadImageRequest;
import com.xforceplus.elephant.image.client.model.BatchMarkRiskRequest;
import com.xforceplus.elephant.image.client.model.BillDetailBean;
import com.xforceplus.elephant.image.client.model.BillSummaryCount;
import com.xforceplus.elephant.image.client.model.CompareSaveBillH5Request;
import com.xforceplus.elephant.image.client.model.GetBaseBillDetailRequest;
import com.xforceplus.elephant.image.client.model.GetBillTypeListRequest;
import com.xforceplus.elephant.image.client.model.GetCountInfoRequest;
import com.xforceplus.elephant.image.client.model.GetDetailResourceCodeRequest;
import com.xforceplus.elephant.image.client.model.HangBillRequest;
import com.xforceplus.elephant.image.client.model.NoticeBaseBillRequest;
import com.xforceplus.elephant.image.client.model.ReCheckBillRequest;
import com.xforceplus.elephant.image.client.model.ReplaceScanUserRequest;
import com.xforceplus.elephant.image.client.model.SplitBillRequest;
import com.xforceplus.elephant.image.client.model.UpdateReceiveStatusRequest;
import com.xforceplus.elephant.image.client.model.UpdateVerifyStatusRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.compare.billdata.process.BackCompareBillDataProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.BatchMarkRiskProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareAuditBillProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareBackBillDataProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareBackBillDeleteProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareBatchDownloadImageProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareGetBackBillOpLogProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareGetBillCodeProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareGetBillImageDetailProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareGetBillTypeListProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareGetDetailResourceCodeProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareGetOrgExtensionsProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareGroupUserProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareHangBillDataProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareOperationDeleteBillProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.ComparePendingBackBaseBillProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.ComparePreCheckBillProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.ComparePrePaymentDeleteProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareReCheckBillProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareReplaceScanUserProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareSaveBillH5Process;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareSplitBillProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareUpdateBillVerifyStatusProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.CompareUpdateReceiveStatusProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.GetCompareBillAuditDetailProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.NoticeCompareBillDataProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.billdetail.CompareGetBillDataImageDetailProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.commit.DefaultCompareBillDataCommitProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.countinfo.DefaultCompareGetBillCountInfoProcess;
import com.xforceplus.elephant.image.controller.compare.billdata.process.delete.DefaultCompareDeleteBillDataProcess;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class CompareBaseBillController extends BaseController implements CompareBaseBillApi {

    @Autowired
    private CompareBackBillDataProcess backBillDataProcess;
    @Autowired
    private CompareHangBillDataProcess hangBillDataProcess;
    @Autowired
    private CompareUpdateBillVerifyStatusProcess updateBillVerifyStatusProcess;
    @Autowired
    private CompareGetBillImageDetailProcess getBillImageDetailProcess;
    @Autowired
    private CompareGetBillCodeProcess getBillCodeProcess;
    @Autowired
    private ComparePrePaymentDeleteProcess prePaymentDeleteProcess;
    @Autowired
    private CompareGetDetailResourceCodeProcess getDetailResourceCodeProcess;
    @Autowired
    private CompareBackBillDeleteProcess billDeleteProcess;
    @Autowired
    private CompareGetOrgExtensionsProcess getOrgExtensionsProcess;
    @Autowired
    private CompareReplaceScanUserProcess replaceScanUserProcess;
    @Autowired
    private CompareGroupUserProcess groupUserProcess;
    @Autowired
    private CompareSplitBillProcess splitBillProcess;
    @Autowired
    private CompareGetBillTypeListProcess getBillTypeListProcess;
    @Autowired
    private CompareGetBackBillOpLogProcess getBackBillOpLogProcess;
    @Autowired
    private ComparePendingBackBaseBillProcess pendingBackBaseBillProcess;
    @Autowired
    private CompareReCheckBillProcess reCheckBillProcess;
    @Autowired
    private CompareAuditBillProcess compareAuditBillProcess;
    @Autowired
    private CompareSaveBillH5Process compareSaveBillH5Process;
    @Autowired
    private GetCompareBillAuditDetailProcess getCompareBillAuditDetailProcess;
    @Autowired
    private BackCompareBillDataProcess backCompareBillDataProcess;
    @Autowired
    private ComparePreCheckBillProcess preCheckBillProcess;
    @Autowired
    private CompareOperationDeleteBillProcess operationDeleteBillProcess;
    @Autowired
    private CompareUpdateReceiveStatusProcess updateReceiveStatusProcess;
    @Autowired
    private NoticeCompareBillDataProcess noticeCompareBillDataProcess;
    @Autowired
    private CompareBatchDownloadImageProcess batchDownloadImageProcess;
    @Autowired
    private BatchMarkRiskProcess batchMarkRiskProcess;

    @Override
    public CommonResponse<BillDetailBean> getBaseBillDetail(final GetBaseBillDetailRequest request) {
        return process(CompareGetBillDataImageDetailProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse<JSONObject> commit(@RequestBody final BaseBillCommitRequest request) {
        return process(DefaultCompareBillDataCommitProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse delete(@RequestBody final BaseBillDeleteRequest request) {
        return process(DefaultCompareDeleteBillDataProcess.class).execute(request);
    }

    @Override
    public CommonResponse<BillSummaryCount> getCountInfo(final GetCountInfoRequest request) {
        return process(DefaultCompareGetBillCountInfoProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse<Integer> hangBill(@RequestBody final HangBillRequest request) {
        return hangBillDataProcess.execute(request);
    }

    @Override
    public CommonResponse orgExtensions(final BaseRequest request) {
        return getOrgExtensionsProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse backBaseBill(@RequestBody final BackBaseBillRequest request) {
        return backBillDataProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse updateVerifyStatus(@RequestBody final UpdateVerifyStatusRequest request) {
        return updateBillVerifyStatusProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse pendingBackBaseBill(@RequestBody final BackBaseBillRequest request) {
        return pendingBackBaseBillProcess.execute(request);
    }

    @RequestMapping(method = RequestMethod.GET, value = "/compare/baseBill/getBillImageDetail/{keyCode}")
    @AuthorizedDefinition(authorization = false)
    public String getBillImageDetail(@PathVariable final String keyCode, final HttpServletRequest req, final HttpServletResponse resp) {
        final String url = getBillImageDetailProcess.process(keyCode);
        if (StringHelp.safeIsEmpty(url)) {
            throw new ElephantException("影像地址无效.");
        }
        final String html = HttpUtils.doGet(url);
        return html.replaceAll("[.]/", "/");
    }

    @Override
    public CommonResponse getBillCode(@PathVariable final String keyCode, @Valid final BaseRequest request) {
        return getBillCodeProcess.execute(keyCode, request);
    }

    @Override
    public CommonResponse getBillTypeList(final GetBillTypeListRequest request) {
        return getBillTypeListProcess.execute(request);
    }

    @Override
    public CommonResponse prePaymentDelete(@RequestBody final BaseBillDeleteRequest request) {
        return prePaymentDeleteProcess.execute(request);
    }

    @Override
    public CommonResponse getDetailResourceCode(@Valid final GetDetailResourceCodeRequest request) {
        return getDetailResourceCodeProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse backBillDelete(@RequestBody final BackBillDeleteRequest request) {
        return billDeleteProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse<Boolean> replaceScanUser(@RequestBody final ReplaceScanUserRequest request) {

        return replaceScanUserProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse split(@RequestBody final SplitBillRequest request) {
        return splitBillProcess.execute(request);
    }

    @Override
    public CommonResponse groupUser(@Valid final BaseRequest request) {
        return groupUserProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse<JSONObject> getBackBillOpLog(@Valid final GetBaseBillDetailRequest request) {
        return getBackBillOpLogProcess.execute(request);
    }

    @Override
    public CommonResponse reCheckBill(@RequestBody final ReCheckBillRequest request) {
        return reCheckBillProcess.execute(request);
    }

    @Override
    public CommonResponse auditBill(@RequestBody final BatchAuditBillRequest request) {
        return compareAuditBillProcess.execute(request);
    }

    @Override
    public CommonResponse compareSaveBillH5(@RequestBody final CompareSaveBillH5Request request) {
        return compareSaveBillH5Process.execute(request);
    }

    @Override
    public CommonResponse getCompareBillAuditDetail(@RequestBody final GetBaseBillDetailRequest request) {
        return getCompareBillAuditDetailProcess.execute(request);
    }

    @Override
    public CommonResponse backCompareBill(@RequestBody final BackCompareBillRequest request) {
        return backCompareBillDataProcess.execute(request);
    }

    @Override
    public CommonResponse noticeBaseBill(@RequestBody NoticeBaseBillRequest request) {
        return noticeCompareBillDataProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("单据预检测")
    @PostMapping("/compare/baseBill/preCheckBill")
    public CommonResponse<String> preCheckBill(@RequestBody final BaseBillCommitRequest request) {
        return preCheckBillProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("运维稽核单据删除")
    @PostMapping("/compare/baseBill/operationDelete")
    public CommonResponse operationDelete(@RequestBody BaseBillDeleteRequest request) {
        return operationDeleteBillProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("变更收单状态")
    @PostMapping("/compare/baseBill/updateReceiveStatus")
    public CommonResponse updateReceiveStatus(@RequestBody UpdateReceiveStatusRequest request) {
        return updateReceiveStatusProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("批量下载影像")
    @PostMapping("/compare/baseBill/downloadImageByBillNo")
    public CommonResponse downloadImageByBillNo(@RequestBody BatchDownloadImageRequest request) {
        return batchDownloadImageProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("批量标记风险单据")
    @PostMapping("/compare/baseBill/batchMarkRisk")
    public CommonResponse batchMarkRisk(@RequestBody BatchMarkRiskRequest request) {
        return batchMarkRiskProcess.execute(request);
    }

}