package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BackBaseBillRequest;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareBackBillDataProcess extends AbstractProcess<BackBaseBillRequest, Boolean> {

    @Autowired
    private CompareBillImageTicketService billImageTicketService;
    @Autowired
    private CompareImageService imageService;

    @Override
    protected void check(BackBaseBillRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "billCodes不能为空");
        checkEmpty(request.getBackReason(), "退回类型不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(BackBaseBillRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        billImageTicketService
            .backBillInfoAndLog(request.getBillCodes(), BackType._2.getCode(), request.getBackReason(), request.getBackRemark(), authorizedUser.getId(), authorizedUser.getUsername(),
                authorizedUser.getTenantId());
        return CommonResponse.ok("成功", true);
    }

}
