package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BackBillDeleteRequest;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import java.util.Arrays;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Deprecated
@Service
public class CompareBackBillDeleteProcess extends AbstractProcess<BackBillDeleteRequest, Integer> {

    @Autowired
    private CompareBaseBillService baseBillService;
    @Autowired
    private CompareBillImageTicketService billImageTicketService;

    @Override
    protected void check(BackBillDeleteRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCode(), "billCode不能为空!");
    }

    @Override
    protected CommonResponse<Integer> process(BackBillDeleteRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final Long tenantId = authorizedUser.getTenantId();
        final BaseBill billEntity = baseBillService.selectBaseBillByCode(tenantId, request.getBillCode());
        if (null == billEntity) {
            return CommonResponse.failed("没有找到业务单数据");
        }
        if (!BackType._2.getCode().equals(billEntity.getBackType())) {
            return CommonResponse.failed("非校验岗退回单据不可删除");
        }
        //删除单据及影像
        final boolean flag = billImageTicketService.deleteBillData(tenantId,
            Arrays.asList(request.getBillCode()), false);
        if (flag) {
            return CommonResponse.ok("成功");
        }
        return CommonResponse.failed("失败");
    }

}
