package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetBaseBillDetailRequest;
import com.xforceplus.elephant.image.core.domain.log.LogService;
import com.xforceplus.elephant.image.core.repository.model.LogBillEntity;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareGetBackBillOpLogProcess extends AbstractProcess<GetBaseBillDetailRequest, JSONObject> {

    @Autowired
    private LogService logService;

    @Override
    protected void check(GetBaseBillDetailRequest request) throws ValidationException {
        if (ValidatorUtil.isEmpty(request.getBillCode())) {
            checkEmpty(request.getBillCode(), "billCode不能为空");
        }
    }

    @Override
    protected CommonResponse<JSONObject> process(GetBaseBillDetailRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final LogBillEntity billEntity = logService.selectBillStatusOpLogOne(authorizedUser.getTenantId(), request.getBillCode(), Integer.valueOf(BillDataStatus._4.getCode()));
        if (null == billEntity) {
            return CommonResponse.failed("未找到操作记录");
        }
        if (StringHelp.safeIsEmpty(billEntity.getContent())) {
            return CommonResponse.failed("未找到操作记录");
        }
        final JSONObject content = JSONObject.parseObject(billEntity.getContent());
        if (null == content) {
            return CommonResponse.failed("未找到操作记录");
        }
        return CommonResponse.ok("成功", content);
    }

}
