package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.baseconst.ConfigConstants;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.system.paas.UserUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.elephant.image.core.domain.config.bean.ConfigDictionaryItem;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.token.domain.IRole;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareGroupUserProcess extends AbstractProcess<BaseRequest, Map<String, String>> {

    @Autowired
    private ConfigDictionaryService configDictionaryService;
    @Autowired
    private UserUtils userUtils;

    @Override
    protected CommonResponse<Map<String, String>> process(BaseRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        final Set<IRole> roles = authorizedUser.getRoles();
        final List<ConfigDictionaryItem> dictionaryItemList = configDictionaryService.selectItems(authorizedUser.getTenantId(), ConfigConstants.CONFIG_DICT_CODE_TEAM_RELATION);
        final Map<String, String> dictionaryMap = dictionaryItemList.stream().collect(Collectors.toMap(ConfigDictionaryItem::getItemCode, ConfigDictionaryItem::getItemValue));
        final String leaderScan = dictionaryMap.get("leaderScan");
        final JSONObject configRoles = JSONArray.parseObject(leaderScan);
        List<Long> queryRoles = Lists.newArrayList();
        if (ValidatorUtil.isEmpty(roles)) {
            return CommonResponse.failed("用户下无角色");
        }
        if (ValidatorUtil.isNotEmpty(configRoles)) {
            for (IRole role : roles) {
                if (configRoles.containsKey(String.valueOf(role.getId()))) {
                    final String roleString = configRoles.getString(String.valueOf(role.getId()));
                    queryRoles.addAll(Arrays.asList(roleString.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()));
                }
            }
        }
        queryRoles = queryRoles.stream().distinct().collect(Collectors.toList());
        if (ValidatorUtil.isEmpty(queryRoles)) {
            return CommonResponse.failed("未获取到用户");
        }
        final JSONArray jsonArray = userUtils.getUsers(authorizedUser.getTenantId(), queryRoles);
        final Map<String, String> map = Maps.newHashMap();
        if (ValidatorUtil.isEmpty(jsonArray)) {
            return CommonResponse.failed("未获取到用户");
        }
        for (int i = 0; i < jsonArray.size(); i++) {
            final String id = jsonArray.getJSONObject(i).getString("id");
            final String userName = jsonArray.getJSONObject(i).getString("userName");
            if (!map.containsKey(id)) {
                map.put(id, userName);
            }
        }
        return CommonResponse.ok("", map);
    }

}
