package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BaseBillDeleteRequest;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComparePrePaymentDeleteProcess extends AbstractProcess<BaseBillDeleteRequest, Boolean> {

    @Autowired
    private CompareBillImageTicketService billImageTicketService;

    @Override
    protected void check(BaseBillDeleteRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "billCodes不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(BaseBillDeleteRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final boolean result = billImageTicketService.deleteBillData(authorizedUser.getTenantId(), request.getBillCodes(), true);
        if (result) {
            return CommonResponse.ok("删除成功", true);
        } else {
            return CommonResponse.failed("无记录删除");
        }
    }

}
