package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.ReplaceScanUserRequest;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareReplaceScanUserProcess extends AbstractProcess<ReplaceScanUserRequest, Boolean> {

    @Autowired
    private CompareBaseBillService baseBillService;

    @Override
    protected void check(ReplaceScanUserRequest request) throws ValidationException {
        checkEmpty(request.getBillCodes(), "业务单号不能为空!");
        checkEmpty(request.getScanUserId(), "扫描人不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(ReplaceScanUserRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文

        final List<BaseBill> billEntityList = baseBillService.selectBillDataByBillCodes(authorizedUser.getTenantId(), request.getBillCodes());
        final List<Long> baseBillId = billEntityList.stream().map(BaseBill::getId).collect(Collectors.toList());
        baseBillId.stream().forEach(billId -> {
            final JSONObject jsonObject = new JSONObject();
            jsonObject.put("scan_user_id", request.getScanUserId());
            jsonObject.put("scan_user_name", request.getScanUserName());
            baseBillService.updateByBillIdSelective(billId, jsonObject);
        });

        return CommonResponse.ok("成功", true);
    }

}
