package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.SplitBillRequest;
import com.xforceplus.elephant.image.core.domain.common.TicketSupport;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.elephant.image.core.expand.bean.BillRecogBean;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareSplitBillProcess extends AbstractProcess<SplitBillRequest, Boolean> {

    @Autowired
    private CompareBaseBillService baseBillService;
    @Autowired
    private CompareImageService imageService;
    @Autowired
    private CompareBillImageTicketService billImageTicketService;
    @Autowired
    private CompareTicketService ticketService;
    @Autowired
    private TicketSupport ticketSupport;

    @Override
    protected void check(SplitBillRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getImageId(), "变更的影像不能为空");
        checkEmpty(request.getBillCode(), "单据号不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(SplitBillRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final BaseBill baseBill = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode());
        if (baseBill != null) {
            throw new ValidationException("此业务单已存在");
        }
        final Image attach = imageService.selectOne(authorizedUser.getTenantId(), request.getImageId());
        checkEmpty(attach, "拆单的影像不存在");
        checkEmpty(attach.getBillCode(), "拆单影像所属单据为空");
        if (!ticketSupport.isAttachSalesImage(attach.getImageType())) {
            throw new ValidationException("拆单的影像不是附件，不能拆单");
        }
        //拆分新旧单数据
        final List<Image> images = imageService.selectImageByBillCode(authorizedUser.getTenantId(), attach.getBillCode());
        final int index = images.indexOf(attach);
        final List<Image> oldBillImages = images.subList(0, index);
        final List<Image> newBillImages = images.subList(index, images.size());
        //更新附件为单据
        final Image newBill = newBillImages.get(0);
        newBill.setImageType(ImageType._1.getCode());
        newBill.setBillCode(request.getBillCode());
        newBill.setBillEntityCode(request.getBillTypeCode());
        newBill.setCreateUserId(authorizedUser.getId());
        newBill.setCreateUserName(authorizedUser.getUsername());
        newBill.setCreateUserCode(authorizedUser.getUserCode());
        newBill.setBillImageId(0L);
        newBill.setTicketImageId(0L);
        //更新封面、删除附件单证、创建单据
        final boolean flag = imageService.updateImageSelective(newBill)
            && ticketService.deleteBaseTicketByImageID(newBill.getId()) > 0
            && toBill(newBill, request) > 0;
        //重算层级
        billImageTicketService.resetLevel(newBillImages, request.getBillCode());
        billImageTicketService.resetLevel(oldBillImages, attach.getBillCode());
        if (flag) {
            return CommonResponse.ok("成功", true);
        } else {
            return CommonResponse.failed("拆单失败");
        }
    }

    private Long toBill(Image image, SplitBillRequest request) {
        final BillRecogBean bean = new BillRecogBean();
        bean.setImageId(image.getId());
        bean.setTenantId(image.getTenantId());
        bean.setBatchNo(image.getBatchNo());
        bean.setIsPublic(image.getIsPublic());
        bean.setScanUserId(image.getCreateUserId());
        bean.setScanUserName(image.getCreateUserName());
        bean.setBillTypeCode(image.getBillEntityCode());
        final JSONObject discern = new JSONObject();
        discern.put("bill_code", image.getBillCode());
        discern.put("bill_amount_with_tax", request.getBillAmountWithTax());
        discern.put("bill_create_user", request.getBillCreateUser());
        discern.put("bill_create_time", request.getBillCreateTime());
        bean.setRecogInfo(discern);
        logger.info("发送单据，imageId:【{}】,bill_code：【{}】", image.getId(), image.getBillCode());
        return billImageTicketService.insertOrUpdateBillRecogInfo(bean);
    }

}
