package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.NoticeBaseBillRequest;
import com.xforceplus.elephant.image.core.business.application.config.common.enums.NoticeTypeEnum;
import com.xforceplus.elephant.image.core.domain.bill.BillNoticeContext;
import com.xforceplus.elephant.image.core.domain.bill.bean.NoticeResult;
import com.xforceplus.elephant.image.core.util.ValidateUtils;
import com.xforceplus.general.utils.EnumUtil;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import java.util.Optional;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class NoticeCompareBillDataProcess extends AbstractProcess<NoticeBaseBillRequest, NoticeResult> {

    @Autowired
    private BillNoticeContext billNoticeContext;

    @Override
    protected void check(NoticeBaseBillRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "billCodes不能为空");
        ValidateUtils.checkNotBlank(request.getType(), "通知类型不能为空");
    }

    @Override
    protected CommonResponse<NoticeResult> process(NoticeBaseBillRequest request) throws RuntimeException {
        Optional.ofNullable(UserInfoHolder.get()).orElseThrow(() -> new ValidationException("获取用户信息为空，请重新登陆"));
        final NoticeTypeEnum noticeType = EnumUtil.fromValue(NoticeTypeEnum.class, request.getType());
        ValidateUtils.checkNotNull(noticeType, String.format("通知类型%s不存在", request.getType()));
        final NoticeResult result = billNoticeContext.choose(noticeType).batchSend(UserInfoHolder.get().getTenantId(), request.getBillCodes(), request.getContent());
        return CommonResponse.ok("通知成功", result);
    }

}