package com.xforceplus.elephant.image.controller.compare.billdata.process.countinfo;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.baseconst.SettingsConstants;
import com.xforceplus.elephant.basecommon.enums.common.PageCodeEnum;
import com.xforceplus.elephant.basecommon.help.DateHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BillSummaryCount;
import com.xforceplus.elephant.image.client.model.GetCountInfoRequest;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Dispatch(isDefault = true)
public class DefaultCompareGetBillCountInfoProcess extends AbstractProcess<GetCountInfoRequest, BillSummaryCount> {

    @Autowired
    private CompareBaseBillService baseBillService;
    @Autowired
    private CompareImageService imageService;
    @Autowired
    private ConfigSettingsService configSettingsService;

    @Override
    protected CommonResponse<BillSummaryCount> process(GetCountInfoRequest request) throws RuntimeException {
        // 获取登录用户上下文
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final Integer isPrePayment = PageCodeEnum.ADVANCE_PAYMENT.getCode().equals(request.getPageCode()) ? 1 : 0;
        if (EntityMeta.CompareBaseBill.code().equals(request.getEntityCode())) {
            request.setEntityCode("");
        }
        final Integer pendingSubmitCount = baseBillService.countBillByTenantIdAndScanUserId(authorizedUser.getTenantId(), Arrays.asList(authorizedUser.getId()), request.getEntityCode(), isPrePayment);
        final Integer exceptionCount = baseBillService
            .countExceptionBillByTenantIdAndScanUserId(authorizedUser.getTenantId(), Arrays.asList(authorizedUser.getId()), request.getEntityCode(), isPrePayment);
        final Integer warningCount = baseBillService
            .countWarningBillByTenantIdAndScanUserId(authorizedUser.getTenantId(), Arrays.asList(authorizedUser.getId()), request.getEntityCode(), isPrePayment);

        final int day = configSettingsService.select(authorizedUser.getTenantId(), SettingsConstants.SEARCH_NO_REAL_DAY, Integer.class, 0);
        final List<Image> imageList = imageService.countImagesNoRelLastDayByCreateUserId(authorizedUser.getId(), day);

        //  查询待提交的租户个人下的单据
        final BillSummaryCount summaryCount = new BillSummaryCount();
        summaryCount.setPendingSubmitCount(pendingSubmitCount);
        summaryCount.setExceptionCount(exceptionCount);
        summaryCount.setWarningCount(warningCount);
        summaryCount.setImageCount(baseBillService.selectTicketImageCount(authorizedUser.getTenantId(), Arrays.asList(authorizedUser.getId()), request.getEntityCode(), isPrePayment));
        summaryCount.setNoRelImageCount(imageList.size());
        summaryCount.setBatchNo(imageList.stream().map(Image::getBatchNo).distinct().collect(Collectors.toList()));
        summaryCount.setStartTime(DateHelp.getDataZero(day));
        summaryCount.setEndTime(DateHelp.getEndTime());
        return CommonResponse.ok("", summaryCount);
    }

}
