package com.xforceplus.elephant.image.controller.compare.billdata.process.delete;

import com.google.api.client.util.Lists;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BaseBillDeleteRequest;
import com.xforceplus.elephant.image.core.business.application.compare.bill.service.CompareBillService;
import com.xforceplus.elephant.image.core.business.application.config.common.domain.CompareScanConfig;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.operationlog.OperationLogService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.AuditStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import java.util.List;
import java.util.Optional;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class DefaultCompareDeleteBillDataProcess extends AbstractProcess<BaseBillDeleteRequest, Boolean> {

    @Autowired
    private CompareBillImageTicketService billImageTicketService;
    @Autowired
    private CompareBaseBillService compareBaseBillService;
    @Autowired
    private BaseBillService baseBillService;
    @Autowired
    private MQUtils rabbitmqUtils;
    @Autowired
    private OperationLogService operationLogService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private CompareBillService compareBillService;

    @Override
    protected void check(BaseBillDeleteRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "billCodes不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(BaseBillDeleteRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();// 获取登录用户上下文
        if (null == user) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final List<BaseBill> billEntityList = compareBaseBillService.selectBillDataByBillCodes(user.getTenantId(), request.getBillCodes());
        if (ValidatorUtil.isEmpty(billEntityList)) {
            return CommonResponse.failed("无记录删除");
        }
        //判断单据下影像是否识别完
        final List<String> updateBillCodes = Lists.newArrayList();
        final List<String> cantDeletedBillCodes = Lists.newArrayList();
        final List<String> issueBillCodes = Lists.newArrayList();
        billEntityList.stream().forEach(baseBill -> {
            if (baseBill.getAuditStatus() != null && (AuditStatus._1.getCode().equals(String.valueOf(baseBill.getAuditStatus())) || AuditStatus._2.getCode()
                .equals(String.valueOf(baseBill.getAuditStatus())))) {
                issueBillCodes.add(baseBill.getBillCode());
            }
            //JXCPX-1935 可删除识别中、转化中数据
            /*final List<Image> images = imageService.selectImageByBillCode(authorizedUser.getTenantId(), baseBill.getBillCode());
            final long count = images.stream()
                .filter(entity -> !Arrays.asList(RecStatus._2.getCode(), RecStatus._3.getCode()).contains(String.valueOf(entity.getRecStatus())))
                .count();
            if (count > 0) {
                cantDeletedBillCodes.add(baseBill.getBillCode());
                return;
            }*/
            updateBillCodes.add(baseBill.getBillCode());
        });
        String message = "删除成功";
        if (ValidatorUtil.isEmpty(updateBillCodes)) {
            message = String.format("单据%s未完成识别，不可删除", StringHelp.join(cantDeletedBillCodes, "、"));
            return CommonResponse.failed(message);
        }
        final CompareScanConfig compareScanConfig = Optional.ofNullable(configService.selectDictObj(user.getTenantId(), DictEnum.COMPARE_SCAN_CONFIG.getCode(), CompareScanConfig.class))
            .orElse(new CompareScanConfig());
        //业务单模式删除提单数据并下发稽核
        if (compareScanConfig.isBizOrder()) {
            compareBillService.deleteMainBillAndPushCompareTicket(user.getTenantId(), updateBillCodes);
        }
        final boolean result = billImageTicketService.deleteBillData(user.getTenantId(), updateBillCodes, false);
        if (result) {
            if (ValidatorUtil.isNotEmpty(cantDeletedBillCodes)) {
                message = String.format("单据%s删除成功；单据%s未完成识别，不可删除",
                    StringHelp.join(updateBillCodes, "、"),
                    StringHelp.join(cantDeletedBillCodes, "、"));
            }
            //同步更新并下发主数据单据信息
            if (ValidatorUtil.isNotEmpty(issueBillCodes) && compareScanConfig.isBillCreate()) {
                compareBillService.resetAuditAndPushMainBill(user.getTenantId(), user.getTenantCode(), issueBillCodes, user.getId(), user.getUserName());
            }
            return CommonResponse.ok(message, true);
        }
        return CommonResponse.failed("删除失败");
    }

}