package com.xforceplus.elephant.image.controller.compare.image;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.NotLog;
import com.xforceplus.elephant.basecommon.annotation.RedisLockMD5;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.compare.CompareImageApi;
import com.xforceplus.elephant.image.client.model.BackTicketRequest;
import com.xforceplus.elephant.image.client.model.BillSelectAllRequest;
import com.xforceplus.elephant.image.client.model.CancelReturnImageRequest;
import com.xforceplus.elephant.image.client.model.CountRecStatusRequest;
import com.xforceplus.elephant.image.client.model.CutImageRequest;
import com.xforceplus.elephant.image.client.model.GetCoverImageListRequest;
import com.xforceplus.elephant.image.client.model.GetImageListRequest;
import com.xforceplus.elephant.image.client.model.GetImageReturnListRequest;
import com.xforceplus.elephant.image.client.model.GetImageStreamRequest;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.client.model.InsertBillImageRequest;
import com.xforceplus.elephant.image.client.model.InsertImageRequest;
import com.xforceplus.elephant.image.client.model.ModifyIsPrintedRequest;
import com.xforceplus.elephant.image.client.model.MoveImageRequest;
import com.xforceplus.elephant.image.client.model.ReturnImageRequest;
import com.xforceplus.elephant.image.client.model.RotateImageRequest;
import com.xforceplus.elephant.image.client.model.SaveImageOrCopyRequest;
import com.xforceplus.elephant.image.client.model.SaveImageRequest;
import com.xforceplus.elephant.image.client.model.UpdateImageRequest;
import com.xforceplus.elephant.image.client.model.UploadRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareBackTicketProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareCancelReturnImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareCountRecStatusProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareCutImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareDeleteCoverImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareGetCoverImageListProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareGetImageDetailProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareGetImageReturnListProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareGetImageStreamProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareInsertBillImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareModifyIsPrintedProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareMoveImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareReTransfromImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareResetImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareReturnImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareRotateImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareSaveCoverImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareSaveImageOrCopyBase64Process;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareUploadImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareUploadMessageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.cover.DefaultCompareReplaceCoverImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.delete.DefaultCompareDeleteImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.imagelist.DefaultCompareImageListProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.insertimage.DefaultCompareInsertImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.personsave.DefaultComparePersonSaveProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.saveimage.DefaultCompareSaveImageProcess;
import com.xforceplus.elephant.image.controller.compare.image.process.unhook.DefaultCompareUnhookImageProcess;
import com.xforceplus.elephant.image.core.business.application.collect.image.domain.UploadMessageResult;
import com.xforceplus.elephant.image.core.business.util.MultiOQSUtil;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.image.bean.ImageSearchResultBean;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class CompareImageController extends BaseController implements CompareImageApi {

    @Autowired
    private CompareGetImageDetailProcess getImageDetailProcess;
    @Autowired
    private CompareGetImageStreamProcess getImageStreamProcess;
    @Autowired
    private CompareSaveImageOrCopyBase64Process saveImageOrCopyBase64Process;
    @Autowired
    private CompareResetImageProcess resetImageProcess;
    @Autowired
    private DefaultCompareImageListProcess imageListProcess;
    @Autowired
    private CompareReturnImageProcess returnImageProcess;
    @Autowired
    private CompareMoveImageProcess moveImageProcess;
    @Autowired
    private CompareCountRecStatusProcess countRecStatusProcess;
    @Autowired
    private CompareGetImageReturnListProcess getImageReturnListProcess;
    @Autowired
    private CompareCancelReturnImageProcess cancelReturnImageProcess;
    @Autowired
    private CompareSaveCoverImageProcess saveCoverImageProcess;
    @Autowired
    private CompareImageService imageService;
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    @Autowired
    private CompareModifyIsPrintedProcess modifyIsPrintedProcess;

    @Autowired
    private CompareRotateImageProcess rotateImageProcess;
    @Autowired
    private CompareGetCoverImageListProcess compareGetCoverImageListProcess;
    @Autowired
    private CompareInsertBillImageProcess insertBillImageProcess;
    @Autowired
    private CompareUploadMessageProcess uploadMessageProcess;
    @Autowired
    private CompareDeleteCoverImageProcess compareDeleteCoverImageProcess;
    @Autowired
    private CompareCutImageProcess compareCutImageProcess;
    @Autowired
    private CompareReTransfromImageProcess reTransfromImageProcess;
    @Autowired
    private CompareUploadImageProcess compareUploadImageProcess;
    @Autowired
    private MultiOQSUtil multiOQSUtil;
    @Autowired
    private ContextService contextService;
    @Autowired
    private CompareBackTicketProcess backTicketProcess;

    @MessageMapping("/compare/userRecStatus/{userId}")
    public void userRecStatus(@DestinationVariable("userId") final long userId) {
        final List<Map<String, Integer>> objs = multiOQSUtil.call(() -> imageService.countRecStatusByCreateUserId(userId));
        final Map<String, Integer> obj = objs.stream().filter(o -> o.values().stream().anyMatch(count -> count > 0)).findFirst().orElse(objs.get(0));
        simpMessagingTemplate.convertAndSend("/topic/compare/user/" + userId, obj);
    }

    @MessageMapping("/compare/billRecStatus/{tenantId}/{billCode}")
    public void billRecStatus(@DestinationVariable("tenantId") final long tenantId, @DestinationVariable("billCode") final String billCode) {
        final String tenantCode = multiOQSUtil.getTenantCodeByTenantId(tenantId);
        final Map<String, Integer> obj = imageService.countRecStatusByBillCode(tenantId, billCode, tenantCode);
        simpMessagingTemplate.convertAndSend("/topic/compare/bill/" + billCode, obj);
    }

    @Override
    public CommonResponse<JSONObject> countRecStatus(final CountRecStatusRequest request) {
        return countRecStatusProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse<Boolean> deleteImage(@RequestBody final BillSelectAllRequest request) {
        return process(DefaultCompareDeleteImageProcess.class).execute(request);
    }

    @Override
    public CommonResponse<ImageDTO> getImageDetail(@PathVariable("imageId") final Long imageId, final BaseRequest request) {
        return getImageDetailProcess.execute(imageId, request);
    }

    @NotLog
    @AuthorizedDefinition(authorization = false)
    @CrossOrigin
    @Override
    public Object getImageFile(@PathVariable("imageId") final Long imageId, @PathVariable("fileExt") final String fileExt, final GetImageStreamRequest request) {
        return getImageStreamProcess.execute(imageId, request);
    }

    @Override
    public CommonResponse<ImageSearchResultBean> getImageList(final GetImageListRequest request) {
        return imageListProcess.execute(request);
    }

    @Override
    public CommonResponse getImageListPost(@RequestBody final GetImageListRequest request) {
        return imageListProcess.execute(request);
    }

    @Override
    public CommonResponse getImageReturnList(final GetImageReturnListRequest request) {
        return getImageReturnListProcess.execute(request);
    }

    @NotLog
    @AuthorizedDefinition(authorization = false)
    @CrossOrigin
    @Override
    public Object getImageStream(@PathVariable("imageId") final Long imageId, final GetImageStreamRequest request) {
        return getImageStreamProcess.execute(imageId, request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse insertImage(@RequestBody final InsertImageRequest request) {
        return process(DefaultCompareInsertImageProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse modifyIsPrinted(@RequestBody final ModifyIsPrintedRequest request) {
        return modifyIsPrintedProcess.execute(request);
    }

    @Override
    public CommonResponse moveImage(@PathVariable("imageId") final Long imageId, @RequestBody final MoveImageRequest request) {
        return moveImageProcess.execute(imageId, request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse personSave(@RequestBody final SaveImageRequest request) {
        return process(DefaultComparePersonSaveProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse replaceCoverImage(@RequestBody final UpdateImageRequest request) {
        return process(DefaultCompareReplaceCoverImageProcess.class).execute(request);
    }

    @Override
    public CommonResponse resetImage(@PathVariable("imageId") final Long imageId, @RequestBody final BaseRequest request) {
        return resetImageProcess.execute(imageId, request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse returnImage(@RequestBody final ReturnImageRequest request) {
        return returnImageProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse<List<Long>> saveImage(@RequestBody final SaveImageRequest request) {
        return process(DefaultCompareSaveImageProcess.class).execute(request);
    }

    @Override
    public CommonResponse<Boolean> saveImageOrCopyByBase64(@PathVariable("imageId") final Long imageId, @RequestBody final SaveImageOrCopyRequest request) {
        return saveImageOrCopyBase64Process.execute(imageId, request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse unhookImage(@RequestBody final BillSelectAllRequest request) {
        return process(DefaultCompareUnhookImageProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse cancelReturnImage(@RequestBody final CancelReturnImageRequest request) {
        return cancelReturnImageProcess.execute(request);
    }

    @Override
    public CommonResponse rotateImage(final Long imageId, @RequestBody final RotateImageRequest request) {

        return rotateImageProcess.execute(imageId, request);
    }

    @Override
    public CommonResponse upload(@RequestBody final UploadRequest request) {
        return compareUploadImageProcess.execute(request);
    }

    @Override
    public CommonResponse getCoverImageList(@Valid final GetCoverImageListRequest request) {
        return compareGetCoverImageListProcess.execute(request);
    }

    @Override
    public CommonResponse saveCoverImage(@RequestBody final SaveImageRequest request) {
        return saveCoverImageProcess.execute(request);
    }

    @Override
    public CommonResponse insertBillImage(@RequestBody final InsertBillImageRequest request) {
        return insertBillImageProcess.execute(request);
    }

    @Override
    public CommonResponse<UploadMessageResult> uploadMessage(@Valid final BaseRequest request) {
        return uploadMessageProcess.execute(request);
    }

    @Override
    public CommonResponse deleteCoverImage(@PathVariable("imageId") final Long imageId, @RequestBody final BaseRequest request) {
        return compareDeleteCoverImageProcess.execute(imageId, request);
    }

    @Override
    public CommonResponse<Long> cutImage(@RequestBody final CutImageRequest request) {
        return compareCutImageProcess.execute(request);
    }

    @Override
    public CommonResponse reTransfromImage(final BillSelectAllRequest request) {
        return reTransfromImageProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("发票退扫")
    @PostMapping("/compare/image/back")
    public CommonResponse backTicket(@RequestBody BackTicketRequest request) {
        return backTicketProcess.execute(request);
    }

}