package com.xforceplus.elephant.image.controller.compare.image.process.cover;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.client.model.UpdateImageRequest;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.Objects;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class DefaultCompareReplaceCoverImageProcess extends AbstractProcess<UpdateImageRequest, Boolean> {

    @Autowired
    private CompareImageService imageService;

    @Override
    protected void check(final UpdateImageRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getEntities(), "替换的封面不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(final UpdateImageRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final Image entity = imageService.selectCoverByBillCode(authorizedUser.getTenantId(), request.getBillCode());
        if (entity == null) {
            return CommonResponse.failed("当前单据没有封面无法替换");
        }
        final ImageDTO newImage = request.getEntities().get(request.getEntities().size() - 1);
        checkEmpty(newImage.getBillCode(), "替换的图片必须是封面");
        if (!Objects.equals(request.getBillCode(), newImage.getBillCode())) {
            return CommonResponse.failed("替换的封面不属于当前单据");
        }
        final boolean result = imageService.updateImageFileUrl(authorizedUser.getTenantId(), entity.getId(),
            newImage.getFileUrlHandle(), newImage.getFileTypeHandle(), authorizedUser.getId(),
            authorizedUser.getUsername());
        return CommonResponse.ok("成功", result);
    }

}
