package com.xforceplus.elephant.image.controller.compare.image.process.delete;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BillSelectAllRequest;
import com.xforceplus.elephant.image.controller.compare.image.process.CompareImageProcessService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class DefaultCompareDeleteImageProcess extends AbstractProcess<BillSelectAllRequest, Boolean> {

    @Autowired
    private CompareBillImageTicketService billImageTicketService;
    @Autowired
    private CompareImageProcessService compareImageProcessService;
    @Autowired
    private CompareImageService imageService;
    @Autowired
    private ExecutorService imageThreadPool;
    @Autowired
    private ContextService contextService;

    @Override
    protected void check(BillSelectAllRequest request) throws ValidationException {
        super.check(request);
        if (request.isAllSelected()) {
            checkEmpty(request.getBillCode(), "billCode参数不能为空");
        }
        if (!request.isAllSelected()) {
            checkEmpty(request.getIncluded(), "影像id不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(BillSelectAllRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        compareImageProcessService.prepareOperateData(request);
        final String message = filter(request);
        if (ValidatorUtil.isEmpty(request.getIds())) {
            return CommonResponse.failed(message);
        }
        final List<Image> images = imageService.selectImages(authorizedUser.getTenantId(), request.getIds());
        final List<String> billCodes = images.stream().map(Image::getBillCode).collect(Collectors.toList());
        final boolean result = billImageTicketService.deleteImageAndTicketByImageIds(authorizedUser.getTenantId(), request.getIds());
        if (result) {
            //JXCPX-2504【碧桂园物业】影像待办上传发票后，报错：单据异常提交失败。
            final String tenantCode = authorizedUser.getTenantCode();
            CompletableFuture.runAsync(() -> {
                try {
                    contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, tenantCode);
                    billCodes.stream().filter(billCode -> imageService.noFinishRecImageCount(authorizedUser.getTenantId(), billCode) > 0)
                        .forEach(billCode -> billImageTicketService.resetLevel(authorizedUser.getTenantId(), billCode));
                } finally {
                    contextService.clear();
                }
            }, imageThreadPool);
            return CommonResponse.ok(message, result);
        }
        return CommonResponse.failed(message);
    }

    protected String filter(BillSelectAllRequest request) {
        //JXCPX-1935 可删除识别中、转化中数据
        /*final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final List<Image> images = imageService.selectImages(authorizedUser.getTenantId(), request.getIds());
        final long count = images.stream()
            .filter(entity -> !Arrays.asList(RecStatus._2.getCode(), RecStatus._3.getCode()).contains(String.valueOf(entity.getRecStatus())))
            .map(entity -> request.getIds().remove(entity.getId()))
            .count();
        if (count > 0) {
            return String.format("共勾选%d条，其中%d条删除成功，%d条未获取识别结果不可删除", images.size(),
                images.size() - count, count);
        }*/
        return "删除成功";
    }

}