package com.xforceplus.elephant.image.controller.compare.image.process.saveimage;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.baseconst.SettingsConstants;
import com.xforceplus.elephant.basecommon.dispatch.BeanDispatcher;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.help.NameUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.system.paas.NotificationUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.client.model.SaveImageRequest;
import com.xforceplus.elephant.image.common.CompareScanCommonService;
import com.xforceplus.elephant.image.config.SwitchProperties;
import com.xforceplus.elephant.image.core.business.application.collect.batch.domain.EnableFlowContext;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.elephant.image.core.business.application.collect.compare.domain.SyncBizOrderBean;
import com.xforceplus.elephant.image.core.business.application.collect.compare.service.SyncCompareService;
import com.xforceplus.elephant.image.core.business.application.config.common.domain.CompareScanConfig;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.business.infrastructure.domain.bizorder.BizOrderMapper;
import com.xforceplus.elephant.image.core.business.infrastructure.domain.bizorder.BizOrderV2VO;
import com.xforceplus.elephant.image.core.business.infrastructure.port.BizOrderService;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.elephant.image.core.facade.application.collect.upload.UploadFacade;
import com.xforceplus.elephant.image.core.repository.model.BatchTaskEntity;
import com.xforceplus.elephant.image.core.util.ImageUtils;
import com.xforceplus.elephant.image.core.util.RequestBuilder;
import com.xforceplus.purchaser.bizratelimiter.model.Application;
import com.xforceplus.purchaser.bizratelimiter.model.BizRequest;
import com.xforceplus.purchaser.bizratelimiter.model.Channel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ExceptionStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.InvoiceStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.sdk.infra.base.id.LongIdGenerator;
import com.xforceplus.xlog.core.model.LogContext;
import io.vavr.Tuple2;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.groovy.util.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class DefaultCompareSaveImageProcess extends AbstractProcess<SaveImageRequest, List<Long>> {

    protected static final String REPEAT_BILL = "[REPEAT_BILL]";

    @Autowired
    protected CompareImageService imageService;
    @Autowired
    protected CompareBaseBillService baseBillService;
    @Autowired
    protected NotificationUtils notificationUtils;
    @Autowired
    protected ConfigSettingsService configSettingsService;
    @Autowired
    protected ConfigDictionaryService configDictionaryService;
    @Autowired
    protected CompareBillImageTicketService billImageTicketService;
    @Autowired
    protected MQUtils rabbitmqUtils;
    @Autowired
    protected BeanDispatcher beanDispatcher;
    @Autowired
    private BaseBillService mainBaseBillService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private BizOrderService bizOrderService;
    @Autowired
    private BizOrderMapper bizOrderMapper;
    @Autowired
    private SyncCompareService syncCompareService;
    @Autowired
    private UploadFacade uploadFacade;
    @Autowired
    private BatchService batchService;
    @Autowired
    private CompareScanCommonService scanCommonService;
    @Autowired(required = false)
    private Application application;
    @Autowired
    private LongIdGenerator longIdGenerator;
    @Autowired
    private SwitchProperties switchProperties;

    @Override
    protected void check(SaveImageRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getEntities(), "操作对象不能为空");
        if (!YesNo._1.getCode().equals(request.getIsPublic())) {
            throw new ValidationException("只能上传公共影像");
        }
        for (ImageDTO entity : request.getEntities()) {
            checkEmpty(entity.getImageCategory(), "影像目录不能为空");
            checkEmpty(entity.getImageSource(), "来源不能为空");
            checkEmpty(entity.getFileUrl(), "原始文件路径不能为空");
            checkEmpty(entity.getFileUrlHandle(), "处理文件路径不能为空");
            checkEmpty(entity.getFileType(), "原始文件类型不能为空");
            checkEmpty(entity.getFileTypeHandle(), "处理文件类型不能为空");
            checkEmpty(entity.getIsPublic(), "是否公共上传不能为空");
        }
    }

    @Override
    protected CommonResponse<List<Long>> process(SaveImageRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final long billCount = request.getEntities().stream()
                                      .filter(dto -> ValidatorUtil.isNotEmpty(dto.getBillCode())).map(r -> r.getBillCode()).distinct()
                                      .count();
        final CompareScanConfig compareScanConfig = Optional.ofNullable(configService.selectDictObj(user.getTenantId(), DictEnum.COMPARE_SCAN_CONFIG.getCode(), CompareScanConfig.class))
                                                            .orElse(new CompareScanConfig());

        //按单据封装请求
        final Map<String, List<ImageDTO>> dtoMap = dtoMap(request);

        //查询已有单据
        final Map<String, BaseBill> billMap = billMap(dtoMap, true);

        //查询进项业务单
        final Tuple2<Map<String, BaseBill>, Map<String, List<Ticket>>> bizOrders =
            compareScanConfig.isBizOrder() ? bizOrders(user.getTenantCode(), dtoMap.keySet()) : new Tuple2<>(new HashMap<>(), new HashMap<>());

        //查询主单据
        final Map<String, BaseBill> mainBillMap = compareScanConfig.isBizOrder() ? bizOrders._1() : billMap(dtoMap, false);
        //根据主单填充发票信息
        dtoMap.forEach((key, dtos) -> dtos.forEach(dto -> {
            final BaseBill bill = mainBillMap.get(key);
            if (bill == null) {
                return;
            }
            dto.setOrgId(bill.getOrgId());
            dto.setOrgCode(bill.getOrgCode());
            dto.setOrgName(bill.getOrgName());
            dto.setBillCode(bill.getBillCode());
            final String billTypeCode =
                StringUtils.startsWith(bill.getBillTypeCode(), "compare") ? bill.getBillTypeCode() : NameUtils.firstLowerName(NameUtils.cameName("compare_" + bill.getBillTypeCode()));
            dto.setBillEntityCode(billTypeCode);
        }));

        //过滤
        final List<Tuple2<Integer, String>> billFilter = billFilter(dtoMap, billMap, mainBillMap);

        //查询主发票
        final Map<String, List<Ticket>> mainTicketList = compareScanConfig.isBizOrder() ? bizOrders._2() : new HashMap<>();

        //保存
        final List<Long> imageIds = switchProperties.isNewCompareSaveImage() ? newSaveImages(dtoMap, mainBillMap, billMap, mainTicketList) : saveImages(dtoMap, mainBillMap, billMap, mainTicketList);

        //消息
        final String message = message(billFilter, billCount);

        if (StringUtils.isNotBlank(message)) {
            return CommonResponse.from(CommonResponse.Fail, message, imageIds);
        }

        LogUtil.attachSaveCount(CollectionUtils.size(request.getEntities()));
        return CommonResponse.ok("成功", imageIds);
    }

    /**
     * 根据单据组装请求dtos
     *
     * @param request request
     * @return
     */
    private Map<String, List<ImageDTO>> dtoMap(final SaveImageRequest request) {
        final Map<String, List<ImageDTO>> dtoMap = new LinkedHashMap<>();
        String billCode = StringUtils.EMPTY;
        final String regexSplit = configSettingsService.select(UserInfoHolder.get().getTenantId(), SettingsConstants.BILL_CODE_REGEX_SPLIT);
        for (ImageDTO entity : request.getEntities()) {
            if (ValidatorUtil.isNotEmpty(entity.getBillCode())) {
                billCode = entity.getBillCode();
                entity.setImageType(ImageType._1.getCode());
                entity.setRequireOcrFlag(YesNo._0.getCode());
                entity.setRecStatus(RecStatus._2.getCode());
                entity.setCalculateStatus(YesNo._1.getCode());
                entity.setSerialNumber(request.getSerialNumber());
                if (ValidatorUtil.isNotEmpty(regexSplit)) {
                    for (String reg : regexSplit.split(",")) {
                        final Pattern pattern = Pattern.compile(reg);
                        final Matcher matcher = pattern.matcher(billCode);
                        if (matcher.find()) {
                            billCode = matcher.group(1);
                            break;
                        }
                    }
                }
                if (dtoMap.containsKey(billCode)) {
                    billCode += REPEAT_BILL;
                }
            } else {
                entity.setRequireOcrFlag(YesNo._1.getCode());
                entity.setRecStatus(RecStatus._0.getCode());
            }
            if (!dtoMap.containsKey(billCode)) {
                dtoMap.put(billCode, new ArrayList<>());
            }
            dtoMap.get(billCode).add(entity);
            entity.setBillCode(billCode);
        }
        return dtoMap;
    }

    /**
     * 根据业务单号查询进项业务单 并返回需要的单据信息和发票信息
     *
     * @param tenantCode 租户代码
     * @param billCodes  业务单号
     * @return 业务单明细
     */
    private Tuple2<Map<String, BaseBill>, Map<String, List<Ticket>>> bizOrders(String tenantCode, Set<String> billCodes) {
        if (CollectionUtils.isEmpty(billCodes)) {
            return new Tuple2<>(new HashMap<>(), new HashMap<>());
        }

        final List<BizOrderV2VO> result = bizOrderService.batchQuery(tenantCode, new ArrayList<>(billCodes));

        if (CollectionUtils.isEmpty(result)) {
            return new Tuple2<>(new HashMap<>(), new HashMap<>());
        }

        //拼装单据
        final Map<String, BaseBill> billMap = bizOrderMapper.mapperBill(result).stream()
                                                            .collect(Collectors.toMap(BaseBill::getBillCode, Function.identity(), (o1, o2) -> o1));

        //拼装单据及发票
        final Map<String, List<Ticket>> ticketListMap = result.stream()
                                                              .filter(bizOrder -> CollectionUtils.isNotEmpty(bizOrder.getRelatedInvoices()))
                                                              .collect(Collectors.toMap(bizOrder -> bizOrder.getBizOrderNo(), bizOrder -> bizOrderMapper.mapperInvoice(bizOrder.getRelatedInvoices()),
                                                                  (o1, o2) -> o1));

        return new Tuple2<>(billMap, ticketListMap);
    }

    /**
     * 根据扫描的单据号查询系统中对应的单据
     *
     * @param dtoMap 单据dtoMap
     * @return
     */
    private Map<String, BaseBill> billMap(Map<String, List<ImageDTO>> dtoMap, boolean isCompare) {
        final List<String> billCodes = dtoMap.keySet().stream()
                                             .filter(billCode -> ValidatorUtil.isNotEmpty(billCode))
                                             .collect(Collectors.toList());
        if (ValidatorUtil.isEmpty(billCodes)) {
            return new HashMap<>();
        }
        final Map<String, BaseBill> billMap = new HashMap<>();
        final long tenantId = UserInfoHolder.get().getTenantId();
        //稽核扫描需要匹配字段
        final List<String> matchFields = configService.selectDict(tenantId, DictEnum.COMPARE_SCAN_MATCH_FIELDS.getCode(), String.class);
        for (String field : matchFields) {
            final RequestBuilder builder = new RequestBuilder()
                .field("tenant_id", ConditionOp.eq, tenantId)
                .field(field, ConditionOp.in, billCodes);
            //确认查询稽核还是主单据
            final List<BaseBill> bills = isCompare ? baseBillService.selectBillDataByRequestBuilder(builder) : mainBaseBillService.selectBillDataByRequestBuilder(builder);
            bills.forEach(bill -> {
                final JSONObject jsonObject = new JSONObject(bill.toOQSMap());
                final String key = jsonObject.getString(field);
                billMap.put(key, bill);
            });
        }
        return billMap;
    }

    /**
     * 单据过滤
     *
     * @param dtoMap  单据dtoMap
     * @param billMap 单据Map
     * @return
     */
    private List<Tuple2<Integer, String>> billFilter(Map<String, List<ImageDTO>> dtoMap,
        Map<String, BaseBill> billMap, Map<String, BaseBill> mainBillMap) {
        final List<Tuple2<Integer, String>> billFilter = new ArrayList<>();
        //扫描过滤
        billFilter.add(scanFilter(dtoMap, billMap));
        //封面过滤
        billFilter.add(coverFilter(dtoMap, billMap));
        //单据不存在或者已作废过滤
        billFilter.add(notLockedFilter(dtoMap, billMap, mainBillMap));
        //重复过滤
        billFilter.add(repeatFilter(dtoMap, billMap));

        //如果单据已存在，则将新影像追加至最后
        final IAuthorizedUser user = UserInfoHolder.get();
        dtoMap.forEach((billCode, dtoList) -> {
            if (!billMap.containsKey(billCode)) {
                return;
            }
            final Image parentImage = uploadFacade.getInsertImage(user.getTenantId(), null, billCode, EntityMeta.CompareImage.code());
            if (parentImage == null || StringUtils.isBlank(parentImage.getFileOrder())) {
                return;
            }
            final AtomicInteger index = new AtomicInteger();
            dtoList.forEach(dto -> dto.setFileOrder(parentImage.getFileOrder() + ImageUtils.sequence(index.getAndIncrement(), dtoList.size())));
            dtoList.stream().findFirst().ifPresent(dto -> dto.setFileOrder("0"));
        });
        return billFilter;
    }

    /**
     * 扫描过滤项
     *
     * @param dtoMap  单据dtoMap
     * @param billMap 单据Map
     */
    private Tuple2<Integer, String> scanFilter(Map<String, List<ImageDTO>> dtoMap, Map<String, BaseBill> billMap) {
        //重复扫描过滤
        final StringBuilder sb = new StringBuilder();
        final List<String> billCodes = dtoMap.keySet().stream()
                                             .filter(code -> ValidatorUtil.isNotEmpty(code))
                                             .filter(code -> code.contains(REPEAT_BILL))
                                             .collect(Collectors.toList());
        billCodes.forEach(code -> {
            final String repeatBillCode = code.replace(REPEAT_BILL, "");
            sb.append("业务单号").append(repeatBillCode)
              .append("挂接了").append(dtoMap.remove(code).size())
              .append("张影像，与同批次扫描的单据重复;\n");
        });
        if (billCodes.size() > 0) {
            return new Tuple2<>(billCodes.size(), sb.toString());
        }
        return new Tuple2<>(0, "");
    }

    /**
     * 封面过滤
     *
     * @param dtoMap  单据dtoMap
     * @param billMap 单据Map
     * @return
     */
    private Tuple2<Integer, String> coverFilter(Map<String, List<ImageDTO>> dtoMap, Map<String, BaseBill> billMap) {
        //没有缺封面的，直接跳过
        if (!dtoMap.containsKey(StringUtils.EMPTY)) {
            return new Tuple2<>(0, "");
        }
        final int count = dtoMap.remove(StringUtils.EMPTY).size();
        if (count > 0) {
            return new Tuple2<>(0, String.format("共有%s张无封面的影像，不可上传，请检查是否有封面;\n", count));
        }
        return new Tuple2<>(0, "");
    }

    /**
     * 单据不存在过滤
     *
     * @param dtoMap  单据dtoMap
     * @param billMap 单据Map
     * @return
     */
    private Tuple2<Integer, String> notLockedFilter(Map<String, List<ImageDTO>> dtoMap, Map<String, BaseBill> billMap, Map<String, BaseBill> mainBillMap) {
        if (ValidatorUtil.isEmpty(dtoMap)) {
            return new Tuple2<>(0, "");
        }
        final List<String> billCodes = dtoMap.keySet().stream()
                                             .filter(billCode -> ValidatorUtil.isNotEmpty(billCode))
                                             .collect(Collectors.toList());
        if (ValidatorUtil.isEmpty(billCodes)) {
            return new Tuple2<>(0, "");
        }
        final CompareScanConfig compareScanConfig = Optional.ofNullable(
                                                                configService.selectDictObj(UserInfoHolder.get().getTenantId(), DictEnum.COMPARE_SCAN_CONFIG.getCode(), CompareScanConfig.class))
                                                            .orElse(new CompareScanConfig());
        final StringBuilder sb = new StringBuilder();
        final long failSize = billCodes.stream().map(billCode -> {
            final BaseBill baseBill = mainBillMap.get(billCode);

            //主流程只校验单据不存在
            if (compareScanConfig.isBillCreate()) {
                //主单据不存在
                if (baseBill == null) {
                    sb.append("扫描单据，").append(billCode)
                      .append("未查询到原始单据，请核实经办人是否已提交单据;\n");
                    dtoMap.remove(billCode);
                    billMap.remove(billCode);
                    return true;
                }
                return false;
            }

            //业务单校验不存在、未开具、已作废
            //主单据不存在
            if (baseBill == null) {
                sb.append("扫描单据，").append(billCode)
                  .append("未进入开票流程，票易通无此单据信息;\n");
                dtoMap.remove(billCode);
                billMap.remove(billCode);
                return true;
            }

            //主单据未完全开票
            if (StringUtils.isNotBlank(baseBill.getReserved2()) && !com.xforceplus.elephant.image.core.business.consts.Constants.TWO.equals(baseBill.getReserved2())) {
                sb.append("扫描单据，").append(billCode)
                  .append("供应商未完成开票，请待供应商开票后再采集;\n");
                dtoMap.remove(billCode);
                billMap.remove(billCode);
                return true;
            }

            //主单据已作废
            if (com.xforceplus.elephant.image.core.business.consts.Constants.ZERO.equals(baseBill.getReserved3())) {
                sb.append("扫描单据，").append(billCode)
                  .append("已作废，请不要采集;\n");
                dtoMap.remove(billCode);
                billMap.remove(billCode);
                return true;
            }

            return false;
        }).filter(flag -> flag).count();

        return new Tuple2<>((int) failSize, sb.toString());

    }

    /**
     * 重复过滤
     *
     * @param dtoMap  单据dtoMap
     * @param billMap 单据Map
     * @return
     */
    private Tuple2<Integer, String> repeatFilter(Map<String, List<ImageDTO>> dtoMap, Map<String, BaseBill> billMap) {
        if (ValidatorUtil.isEmpty(billMap)) {
            return new Tuple2<>(0, "");
        }
        final List<String> billCodes = billMap.entrySet().stream().filter(entry ->
                                                  !Objects.equals(BillDataStatus._0.getCode(), entry.getValue().getBillDataStatus())
                                              ).map(entry -> entry.getKey())
                                              .collect(Collectors.toList());
        if (ValidatorUtil.isEmpty(billCodes)) {
            return new Tuple2<>(0, "");
        }
        final StringBuilder sb = new StringBuilder();
        //单据号JW131903292，挂接单证10张,
        //与[扫描批次: 19-1203-0987, 扫描人:张三]重复
        //单据号XXXXX在[扫描时间：xxxx:xx:xx]被[扫描人：XXX]采集过，请勿重复采集
        billCodes.forEach(billCode -> {
            final BaseBill billEntity = billMap.get(billCode);
            sb.append("单据号");
            sb.append(billCode)
              .append("在[扫描时间：")
              .append(DateUtil.format(Date.from(billEntity.getScanCreateTime().toInstant(ZoneOffset.ofHours(8))), "yyyy-MM-dd HH:mm:ss"))
              .append("]被[扫描人：").append(billEntity.getScanUserName()).append("]采集过，请勿重复采集;\n");

            billMap.remove(billCode);
            dtoMap.remove(billCode);
        });
        return new Tuple2<>(billCodes.size(), sb.toString());
    }

    /**
     * 存储影像
     *
     * @param dtoMap 单据dtoMap
     * @return
     */
    private List<Long> saveImages(Map<String, List<ImageDTO>> dtoMap, Map<String, BaseBill> mainBillMap, Map<String, BaseBill> billMap, Map<String, List<Ticket>> billTicketMap) {
        final IAuthorizedUser user = UserInfoHolder.get();
        final String batchNo = Long.toString(System.currentTimeMillis());
        final List<Image> images = new ArrayList<>();
        dtoMap.forEach((key, dtos) -> {
            dtos.forEach(dto -> {
                final Image entity = Image.fromOQSMap(BeanUtils.convertJSON(dto));
                entity.setBatchNo(batchNo);
                entity.setFileOrder("");
                entity.setTenantId(user.getTenantId());
                entity.setTenantCode(user.getTenantCode());
                entity.setStatus(ImageStatus._1.getCode());
                entity.setIsManualUnhook(YesNo._0.getCode());
                entity.setExceptionStatus(ExceptionStatus._0.getCode());
                entity.setReturnStatus(BackType._0.getCode());
                entity.setFileUrlLocal(StringUtils.EMPTY);
                entity.setCreateUserCode(user.getUserCode());
                entity.setCreateUserId(user.getId());
                entity.setCreateUserName(user.getUsername());
                entity.setCreateTime(LocalDateTime.now());
                images.add(entity);
            });
            //同步电票
            if (!billTicketMap.containsKey(key)) {
                return;
            }
            final List<Ticket> tickets = billTicketMap.get(key).stream()
                                                      .filter(ticket -> com.xforceplus.elephant.image.core.business.consts.Constants.ELECTRIC_INVOICE_TYPE.contains(ticket.getInvoiceType()))
                                                      .filter(ticket -> !InvoiceStatus._2.getCode().equals(ticket.getInvoiceStatus()))
                                                      .map(ticket -> {
                                                          ticket.setBatchNo(batchNo);
                                                          return ticket;
                                                      }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tickets)) {
                return;
            }
            final SyncBizOrderBean bean = SyncBizOrderBean.builder()
                                                          .tenantId(user.getTenantId())
                                                          .isCompare(true)
                                                          .lastFileOrder(Integer.toString(dtos.size()))
                                                          .userId(user.getId())
                                                          .userName(user.getUserName())
                                                          .userCode(user.getUserCode())
                                                          .build();
            toElectricTicket(bean, Optional.ofNullable(mainBillMap.get(key)).orElse(new BaseBill()), tickets);
        });
        final EnableFlowContext context = new EnableFlowContext().setTenantId(user.getTenantId()).setUserId(user.getId());
        final boolean flag = CollectionUtils.isNotEmpty(images) && batchService.enable(context);
        LogContext.setLogPoint("enableFlow", flag);
        if (flag) {
            final String channelCode = batchService.getChannelCode(user.getTenantCode());
            final BatchTaskEntity batchTaskEntity = new BatchTaskEntity();
            batchTaskEntity.setTenantId(user.getTenantId());
            batchTaskEntity.setTenantCode(user.getTenantCode());
            batchTaskEntity.setCreateUserId(user.getId());
            batchTaskEntity.setCreateUserName(user.getUsername());
            batchTaskEntity.setCreateTime(new Date());
            batchTaskEntity.setTaskCount(images.size());
            batchTaskEntity.setChannelCode(channelCode);
            final Long batchId = batchService.insert(batchTaskEntity);
            images.forEach(image -> image.setBatchNo(String.valueOf(batchId)));
            final Map<String, Object> headers = new HashMap<>();
            headers.put(com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE, user.getTenantCode());
            headers.put("batchNo", batchId);
            headers.put("userInfo", JSONObject.toJSONString(user));
            final JSONObject message = new JSONObject();
            message.put("mainBillMap", mainBillMap);
            message.put("images", images);
            message.put("billMap", billMap);
            try {
                if (batchService.sendEnableFlow(context)) {
                    LogUtil.attachEnableFlow(batchId.toString(), MQEnum.COMPARE_SAVE_IMAGE_SYNC_QUEUE);
                    final Channel channel = application.loadChannel(channelCode);
                    final BizRequest bizRequest = BizRequest.builder()
                                                            .bizQuantity(batchTaskEntity.getTaskCount())
                                                            .properties(headers)
                                                            .body(message.toJSONString())
                                                            .attrs(Maps.of("queueName", MQEnum.COMPARE_SAVE_IMAGE_SYNC_QUEUE))
                                                            .build();
                    channel.flowInRateLimit(bizRequest);
                } else {
                    rabbitmqUtils.sendByDirectExchange(MQEnum.COMPARE_SAVE_IMAGE_SYNC_QUEUE, message.toJSONString(), headers);
                }
            } catch (Exception e) {
                LogContext.setLogPoint("enableFlowError", e.getMessage());
                logger.error("使用限流异常", e);
                LogContext.setLogPoint("error", String.format("使用限流异常:%s", e.getMessage()));
                rabbitmqUtils.sendByDirectExchange(MQEnum.COMPARE_SAVE_IMAGE_SYNC_QUEUE, message.toJSONString(), headers);
            }
            return new ArrayList<>();
        }
        //保存影像
        final List<Long> imageIds = scanCommonService.saveImage(images, mainBillMap, user.getId());
        return imageIds;
    }

    /**
     * 同步电票
     *
     * @param bean       同步配置
     * @param billEntity 单据
     * @param tickets    单证
     */
    private void toElectricTicket(SyncBizOrderBean bean, BaseBill billEntity, List<Ticket> tickets) {
        final List<Long> ticketIds = syncCompareService.syncTicketByBizOrder(bean, billEntity, tickets);
        //批量计算
        final Map<String, Object> headers = new HashMap<>();
        headers.put(TENANT_CODE, UserInfoHolder.get().getTenantCode());
        ticketIds.forEach(id -> {
            //发送mq,校验单证异常预警信息
            final Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("ticketId", id);
            paramMap.put("ticketCode", EntityMeta.CompareTicketInvoice.code());
            paramMap.put("source", "同步电票");
            rabbitmqUtils.sendByDirectExchange(MQEnum.COMPARE_CHECK_TICKET_EXCE_WARN_QUEUE, paramMap, headers);
        });
    }

    /**
     * 过滤消息整理
     *
     * @param billCount billCount
     * @return
     */
    private String message(List<Tuple2<Integer, String>> billFilter, long billCount) {
        int count = 0;
        final StringBuilder sb = new StringBuilder();
        for (Tuple2<Integer, String> filter : billFilter) {
            count += filter._1;
            sb.append(filter._2);
        }
        final StringBuilder message = new StringBuilder();
        if (count > 0 || sb.length() > 0) {
            final String title = "影像上传提醒";
            message.append("本批次共扫描单据").append(billCount).append("份");
            if (count > 0) {
                message.append("，其中").append(count).append("份").append("被拦截");
            }
            message.append("：\n").append(sb);
            notificationUtils.sendSingleMessage(UserInfoHolder.get().getTenantId(),
                Collections.singletonList(UserInfoHolder.get().getId()), title, message.toString());
        }
        return message.toString();
    }

    /**
     * 存储影像
     *
     * @param dtoMap 单据dtoMap
     * @return
     */
    private List<Long> newSaveImages(Map<String, List<ImageDTO>> dtoMap, Map<String, BaseBill> mainBillMap, Map<String, BaseBill> billMap, Map<String, List<Ticket>> syncBillTicketMap) {
        final IAuthorizedUser user = UserInfoHolder.get();
        final String batchNo = Long.toString(System.currentTimeMillis());
        final List<Image> images = new ArrayList<>();
        final List<Long> imageIds = new ArrayList<>();
        dtoMap.forEach((key, dtos) -> {
            final AtomicInteger index = new AtomicInteger();
            dtos.forEach(dto -> {
                final Image entity = Image.fromOQSMap(BeanUtils.convertJSON(dto));
                entity.setId(longIdGenerator.next());
                imageIds.add(entity.getId());
                entity.setBatchNo(batchNo);
                entity.setFileOrder(ImageUtils.sequence(index.incrementAndGet(), dtos.size()));
                entity.setTenantId(user.getTenantId());
                entity.setStatus(ImageStatus._1.getCode());
                entity.setIsManualUnhook(YesNo._0.getCode());
                entity.setExceptionStatus(ExceptionStatus._0.getCode());
                entity.setReturnStatus(BackType._0.getCode());
                entity.setFileUrlLocal(StringUtils.EMPTY);
                entity.setCreateUserCode(user.getUserCode());
                entity.setCreateUserId(user.getId());
                entity.setCreateUserName(user.getUsername());
                entity.setCreateTime(LocalDateTime.now());
                images.add(entity);
            });
            //同步电票
            if (!syncBillTicketMap.containsKey(key)) {
                return;
            }
            final List<Ticket> tickets = syncBillTicketMap.get(key).stream()
                                                          .filter(ticket -> com.xforceplus.elephant.image.core.business.consts.Constants.ELECTRIC_INVOICE_TYPE.contains(ticket.getInvoiceType()))
                                                          .filter(ticket -> !InvoiceStatus._2.getCode().equals(ticket.getInvoiceStatus()))
                                                          .map(ticket -> {
                                                              ticket.setBatchNo(batchNo);
                                                              return ticket;
                                                          }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tickets)) {
                return;
            }
            final SyncBizOrderBean bean = SyncBizOrderBean.builder()
                                                          .tenantId(user.getTenantId())
                                                          .isCompare(true)
                                                          .lastFileOrder(Integer.toString(dtos.size()))
                                                          .userId(user.getId())
                                                          .userName(user.getUserName())
                                                          .userCode(user.getUserCode())
                                                          .build();
            toElectricTicket(bean, Optional.ofNullable(mainBillMap.get(key)).orElse(new BaseBill()), tickets);
        });
        final EnableFlowContext context = new EnableFlowContext().setTenantId(user.getTenantId()).setUserId(user.getId());
        final boolean flag = CollectionUtils.isNotEmpty(images) && batchService.enable(context);
        LogContext.setLogPoint("enableFlow", flag);
        if (flag) {
            final String channelCode = batchService.getChannelCode(user.getTenantCode());
            final BatchTaskEntity batchTaskEntity = new BatchTaskEntity();
            batchTaskEntity.setTenantId(user.getTenantId());
            batchTaskEntity.setTenantCode(user.getTenantCode());
            batchTaskEntity.setCreateUserId(user.getId());
            batchTaskEntity.setCreateUserName(user.getUsername());
            batchTaskEntity.setCreateTime(new Date());
            batchTaskEntity.setTaskCount(images.size());
            batchTaskEntity.setChannelCode(channelCode);
            final Long batchId = batchService.insert(batchTaskEntity);
            images.forEach(image -> image.setBatchNo(String.valueOf(batchId)));
            final Map<String, Object> headers = new HashMap<>();
            headers.put(com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE, user.getTenantCode());
            headers.put("batchNo", batchId);
            headers.put("userInfo", JSONObject.toJSONString(user));
            final JSONObject message = new JSONObject();
            message.put("mainBillMap", mainBillMap);
            message.put("images", images);
            message.put("billMap", billMap);
            try {
                if (batchService.sendEnableFlow(context)) {
                    final Channel channel = application.loadChannel(channelCode);
                    final BizRequest bizRequest = BizRequest.builder()
                                                            .bizQuantity(batchTaskEntity.getTaskCount())
                                                            .properties(headers)
                                                            .body(message.toJSONString())
                                                            .attrs(Maps.of("queueName", MQEnum.COMPARE_SAVE_IMAGE_SYNC_QUEUE))
                                                            .build();
                    channel.flowInRateLimit(bizRequest);
                } else {
                    rabbitmqUtils.sendByDirectExchange(MQEnum.COMPARE_SAVE_IMAGE_SYNC_QUEUE, message.toJSONString(), headers);
                }
            } catch (Exception e) {
                LogContext.setLogPoint("enableFlowError", e.getMessage());
                logger.error("使用限流异常", e);
                LogContext.setLogPoint("error", String.format("使用限流异常:%s", e.getMessage()));
                rabbitmqUtils.sendByDirectExchange(MQEnum.COMPARE_SAVE_IMAGE_SYNC_QUEUE, message.toJSONString(), headers);
            }
            return imageIds;
        }
        //保存影像
        scanCommonService.newSaveImage(images, mainBillMap, billMap, user.getId());
        return imageIds;
    }

}