package com.xforceplus.elephant.image.controller.compare.image.process.unhook;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BillSelectAllRequest;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.image.bean.ImageSearchBean;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.elephant.image.core.facade.application.collect.image.ImageFacade;
import com.xforceplus.elephant.image.mapper.ImageSearchMapper;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class DefaultCompareUnhookImageProcess extends AbstractProcess<BillSelectAllRequest, Boolean> {

    @Autowired
    private CompareImageService imageService;
    @Autowired
    private ImageFacade imageFacade;
    @Autowired
    private ImageSearchMapper mapper;
    @Autowired
    private CompareBillImageTicketService billImageTicketService;
    @Autowired
    private ExecutorService imageThreadPool;
    @Autowired
    private ContextService contextService;

    @Override
    protected void check(BillSelectAllRequest request) throws ValidationException {
        super.check(request);
        if (request.isAllSelected()) {
            checkEmpty(request.getBillCode(), "单据code不能为空");
        }
        if (!request.isAllSelected()) {
            checkEmpty(request.getIncluded(), "影像id不能为空");
        }
    }

    protected String filter(BillSelectAllRequest request) {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final List<Image> images = imageService.selectImages(authorizedUser.getTenantId(), request.getIds());
        final long count = images.stream()
            .filter(entity -> !Arrays.asList(RecStatus._2.getCode(), RecStatus._3.getCode()).contains(String.valueOf(entity.getRecStatus())))
            .map(entity -> request.getIds().remove(entity.getId()))
            .count();
        if (count > 0) {
            return String.format("共勾选%d条，其中%d条脱挂成功，%d条未获取识别结果不可脱挂", images.size(),
                images.size() - count, count);
        }
        return "成功";
    }

    /**
     * 准备要操作的数据 格式化全选反选数据到ids 需要注意此处是要考虑全选操作是带着筛选条件的
     *
     * @param request 请求
     * @return void
     * @author liming
     * @date 2021/7/30 11:18
     */
    private void prepareOperateData(BillSelectAllRequest request) {
        //全选
        final IAuthorizedUser user = UserInfoHolder.get();
        if (request.isAllSelected()) {
            //条件筛选
            final ImageSearchBean searchBean = mapper.map(request);
            searchBean.setTenantId(user.getTenantId());
            final List<Image> imageList = imageFacade.selectBillImagesByCustomTicketParams(searchBean, EntityMeta.CompareImage.code()).getRows();
            final List<Long> ids = imageList.stream()
                .filter(image -> !ImageType._1.getCode().equals(image.getImageType()))
                .map(image -> image.getId())
                .collect(Collectors.toList());
            if (ValidatorUtil.isNotEmpty(request.getExcluded())) {
                final List<Long> excludedList = request.getExcluded().stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
                ids.removeAll(excludedList);
            }
            request.setIds(ids);
        }
        //非全选
        if (!request.isAllSelected()) {
            final List<Long> ids = request.getIncluded().stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
            request.setIds(ids);
        }
    }

    @Override
    protected CommonResponse<Boolean> process(BillSelectAllRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        prepareOperateData(request);
        final String message = filter(request);
        final boolean result = billImageTicketService.unhookImages(authorizedUser.getTenantId(), request.getBillCode(), request.getIds());
        if (result) {
            final String tenantCode = authorizedUser.getTenantCode();
            CompletableFuture.runAsync(() -> {
                try {
                    contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, tenantCode);
                    billImageTicketService.resetLevel(authorizedUser.getTenantId(), request.getBillCode());
                } finally {
                    contextService.clear();
                }
            }, imageThreadPool);
            return CommonResponse.ok(message, result);
        }
        return CommonResponse.failed(message);
    }

}