package com.xforceplus.elephant.image.controller.compare.ticket.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.DeleteBackTicketsRequest;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
@RequiredArgsConstructor
public class CompareDeleteBackTicketsProcess extends AbstractProcess<DeleteBackTicketsRequest, Boolean> {

    private final CompareBillImageTicketService compareBillImageTicketService;

    @Override
    protected void check(DeleteBackTicketsRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getImageIds(), "imageId不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(DeleteBackTicketsRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final boolean result = compareBillImageTicketService.deleteImageAndTicketByImageIds(user.getTenantId(), request.getImageIds());
        return CommonResponse.ok("成功", result);
    }

}
