package com.xforceplus.elephant.image.controller.compare.ticket.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.baseconst.ConfigConstants;
import com.xforceplus.elephant.basecommon.enums.common.PageCodeEnum;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.help.NameUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.model.GetTicketDetailRequest;
import com.xforceplus.elephant.image.client.model.ImageCopyDTO;
import com.xforceplus.elephant.image.client.model.TicketBean;
import com.xforceplus.elephant.image.core.business.application.collect.bill.service.BillService;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.domain.TicketTypeConfig;
import com.xforceplus.elephant.image.core.business.application.config.common.domain.WatermarkConfig;
import com.xforceplus.elephant.image.core.business.application.config.common.domain.WatermarkContext;
import com.xforceplus.elephant.image.core.business.application.config.common.domain.WatermarkScene;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.config.bean.ConfigDictionaryItem;
import com.xforceplus.elephant.image.core.domain.image.ImageCopyService;
import com.xforceplus.elephant.image.core.facade.application.collect.label.SystemLabelFacade;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import com.xforceplus.elephant.image.core.util.FileHelpUtils;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageCopy;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.SystemLabel;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.ConfigSettings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.assertj.core.util.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompareGetTicketDetailProcess extends AbstractProcess<GetTicketDetailRequest, JSONObject> {

    @Autowired
    private CompareImageService imageService;
    @Autowired
    private ImageCopyService imageCopyService;
    @Autowired
    private CompareTicketService ticketService;
    @Autowired
    private ConfigSettingsService configSettingsService;
    @Autowired
    private ConfigDictionaryService configDictionaryService;
    @Autowired
    private SystemLabelFacade systemLabelFacade;
    @Autowired
    private TicketFacade ticketFacade;
    @Autowired
    private ConfigService configService;
    @Autowired
    private BillService billService;

    @Override
    protected void check(final GetTicketDetailRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getImageId())) {
            throw new ValidationException("影像ID【imageId】不能为空");
        }
    }

    @Override
    protected CommonResponse<JSONObject> process(final GetTicketDetailRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        JSONObject jsonObject = new JSONObject();
        //1.影像地址
        final Image image = imageService.selectOne(authorizedUser.getTenantId(), request.getImageId());
        if (null == image) {
            return CommonResponse.SPECIAL("没有找到影像.");
        }
        jsonObject.put("fileName", image.getFileName());

        final List<String> tenantCodes = configService.selectDict(authorizedUser.getTenantId(), DictEnum.NEED_WRAPPER_URL_TENANT_CONFIG.getCode(), String.class);
        String fileUrl = ApiV1Image.PATH + "/compare/image/" + image.getId() + image.getFileTypeHandle() + "?rid=" + System.currentTimeMillis();
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(tenantCodes) && !org.apache.commons.collections4.CollectionUtils.containsAny(tenantCodes, authorizedUser.getTenantCode())
            && !ImageType._3.getCode().equals(image.getImageType())) {
            fileUrl = ValidatorUtil.isNotEmpty(image.getFileUrlLocal()) ? image.getFileUrlLocal() : image.getFileUrlHandle();
        }
        jsonObject.put("imageUrl", fileUrl);

        //文件类型的时候返回此地址
        jsonObject.put("imageType", image.getImageType());
        if (ValidatorUtil.isNotEmpty(image.getImageType()) && ImageType._5.getCode().equals(image.getImageType())) {
            if (request.isNeedBase64()) {
                jsonObject.put("origImageBase64", FileHelpUtils.httpURlToBase64(image.getFileUrl()));
            }
            final String tempUrl = image.getFileUrl().replaceFirst("http://", "https://");
            jsonObject.put("origImageUrl", tempUrl);

        }
        jsonObject.put("fileType", image.getFileType());
        if (ValidatorUtil.isNotEmpty(image.getFileUrlOrigin())) {
            jsonObject.put("isOriginImage", 1);//原图
        } else {
            jsonObject.put("isOriginImage", 0);
        }
        //2.影像副本list
        getImageCopyList(jsonObject, authorizedUser.getTenantId(), request.getImageId(), request.getRid());
        //单证基础数据list
        List<Ticket> entityList = ticketService.selectBaseTicketByImageID(request.getImageId());
        if (CollectionUtils.isEmpty(entityList)) {
            jsonObject.put("ticketList", Collections.emptyList());
            //水印
            watermarkConfig(jsonObject, image, null);
            return CommonResponse.ok("成功", jsonObject);
        }
        //过滤虚拟单证
        entityList = entityList.stream().filter(r -> !EntityMeta.CompareTicketVirtual.code().equals(r.getTicketCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entityList)) {
            jsonObject.put("ticketList", Collections.emptyList());
            //水印
            watermarkConfig(jsonObject, image, null);
            return CommonResponse.ok("成功", jsonObject);
        }
        Map<String, ConfigDictionaryItem> dictionaryMap = Maps.newHashMap();
        final List<ConfigDictionaryItem> dictionaryItemList = configDictionaryService.selectItems(authorizedUser.getTenantId(), ConfigConstants.CONFIG_DICT_CODE_TICKET_CHEKCT_CONTENT);
        if (!CollectionUtils.isEmpty(dictionaryItemList)) {
            dictionaryMap = dictionaryItemList.stream().collect(Collectors.toMap(ConfigDictionaryItem::getItemCode, a -> a, (k1, k2) -> k1));
        }
        final List<TicketBean> ticketBeans = getTicketDataList(entityList, authorizedUser.getTenantId(), authorizedUser.getTenantCode(), request.getPageCode(), dictionaryMap);
        jsonObject.put("ticketList", ticketBeans);
        //3.单证标签
        jsonObject = getTickeLabelList(jsonObject, ticketBeans);
        //水印
        watermarkConfig(jsonObject, image, entityList);
        return CommonResponse.ok("成功", jsonObject);
    }

    /**
     * 获取影像副本
     *
     * @param jsonObject json对象
     * @param imageId    影像ID
     */
    private void getImageCopyList(final JSONObject jsonObject, final Long tenantId, final Long imageId, final String rid) {
        //影像副本list
        final List<ImageCopy> copyEntities = imageCopyService.selectImageCopies(tenantId, imageId);
        if (CollectionUtils.isEmpty(copyEntities)) {
            jsonObject.put("imageCopyList", Collections.emptyList());
        }
        final List<ImageCopyDTO> copyList = copyEntities.stream().map(entity -> {
            final ImageCopyDTO dto = new JSONObject(entity.toOQSMap()).toJavaObject(ImageCopyDTO.class);
            dto.setFileUrl("/api/image-service-saas/v1/imageCopy/" + entity.getId() + entity.getFileType());
            return dto;
        }).collect(Collectors.toList());
        jsonObject.put("imageCopyList", copyList);
    }

    /**
     * 获取单证数据
     *
     * @param entityList entityList
     * @return
     */
    private List<TicketBean> getTicketDataList(final List<Ticket> entityList, final Long tenantId, final String tenantCode, final String pageCode,
        final Map<String, ConfigDictionaryItem> dictionaryMap) {
        //jira-1572 租户是否开启非增票权限校验
        final String checkNVatPermissionValue = configSettingsService
            .select(tenantId, ConfigSettings.IS_CHECK_N_VAT_PERMISSION.code(), String.class, YesNo._0.getCode());
        final List<TicketBean> resultBean = Lists.newArrayList();
        final String newPageCode = ValidatorUtil.isEmpty(pageCode) ? PageCodeEnum.PERSON_TICKET.getCode() : pageCode;
        final List<TicketTypeConfig> ticketTypeList = ticketFacade.getTicketTypeList(tenantId, newPageCode);
        final Map<String, String> pageMap = Maps.newHashMap();
        ticketTypeList.forEach(r -> pageMap.put(r.getBoCode(), ValidatorUtil.isNotEmpty(r.getRemark()) ? r.getRemark() : r.getBoName()));
        entityList.forEach(entity -> {
            final TicketBean bean = JSON.parseObject(JSON.toJSONString(entity), TicketBean.class);
            bean.setIsCheckNVatPermission(checkNVatPermissionValue);
            //单证名称
            final String ticketCode = NameUtils.firstLowerName(bean.getTicketCode().replaceAll("compare", ""));
            if (null != pageMap && pageMap.get(ticketCode) != null) {
                bean.setTicketCodeName(pageMap.get(ticketCode));
            }
            //多票排序
            if (EntityMeta.CompareTicketMany.code().equals(ticketCode)) {
                resultBean.add(0, bean);
            } else {
                resultBean.add(bean);
            }
        });
        return resultBean;
    }

    /**
     * 获取单证标签数据
     *
     * @param jsonObject  json对象
     * @param ticketBeans ticketBeans
     * @return
     */
    private JSONObject getTickeLabelList(final JSONObject jsonObject, final List<TicketBean> ticketBeans) {
        final String labelIds = ticketBeans.stream().filter(r -> !StringHelp.safeIsEmpty(r.getTicketLabel()))
            .map(r -> r.getTicketLabel()).collect(Collectors.joining(","));
        if (ValidatorUtil.isEmpty(labelIds)) {
            return jsonObject;
        }
        final List<Long> labelIdList = Arrays.stream(labelIds.split(",")).map(r -> Long.valueOf(r)).distinct().collect(Collectors.toList());
        final List<SystemLabel> labelList = systemLabelFacade.selectList(labelIdList);
        final Map<Long, String> labelMap = labelList.stream().collect(Collectors.toMap(SystemLabel::getId, SystemLabel::getLabelName));
        //4.组装单证与标签关系
        ticketBeans.forEach(r -> {
            final String labelStr = r.getTicketLabel();
            if (ValidatorUtil.isEmpty(labelStr)) {
                return;
            }
            final List<JSONObject> resultList = Lists.newArrayList();
            Arrays.stream(labelStr.split(",")).forEach(l -> {
                if (ValidatorUtil.isEmpty(labelMap.get(Long.valueOf(l)))) {
                    return;
                }
                final JSONObject json = new JSONObject();
                json.put("id", Long.valueOf(l));
                json.put("labelName", labelMap.get(Long.valueOf(l)));
                resultList.add(json);
            });
            r.setLabelList(resultList);
        });
        jsonObject.put("ticketList", ticketBeans);
        return jsonObject;
    }

    /**
     * 设置水印
     *
     * @param jsonObject  输出结果
     * @param image 影像
     * @param entityList  单证对象
     */
    private void watermarkConfig(final JSONObject jsonObject, final Image image, final List<Ticket> entityList) {
        final WatermarkConfig watermarkConfig = configService.selectDictObj(UserInfoHolder.get().getTenantId(), DictEnum.WATERMARK_CONFIG.getCode(), WatermarkConfig.class);
        if (watermarkConfig == null || !watermarkConfig.enable()) {
            return;
        }
        BaseBill baseBill = null;
        if (ValidatorUtil.isNotEmpty(image.getBillCode())) {
            baseBill = billService.selectBaseBillByCode(image.getTenantId(), image.getBillCode(), EntityMeta.CompareBaseBill.code());
        }
        final WatermarkContext context = new WatermarkContext();
        context.setScene(WatermarkScene.lookup);
        context.setImage(BeanUtils.convertJSON(image));
        Optional.ofNullable(baseBill).ifPresent(bill -> context.setBill(bill.toOQSMap()));
        Optional.ofNullable(entityList).filter(tickets -> !CollectionUtils.isEmpty(tickets))
            .ifPresent(tickets -> context.setTicket(BeanUtils.convertJSON(tickets.get(0))));
        context.setUserInfo(UserInfoHolder.get());
        jsonObject.put("waterString", watermarkConfig.watermark(context));
    }

}