package com.xforceplus.elephant.image.controller.compare.ticket.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.ReSendTicketRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.elephant.image.core.domain.operationlog.OperationLogService;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareReSendTicketProcess extends AbstractProcess<ReSendTicketRequest, Boolean> {

    @Autowired
    private CompareTicketService ticketService;
    @Autowired
    private MQUtils rabbitmqUtils;
    @Autowired
    private OperationLogService operationLogService;

    @Override
    protected void check(ReSendTicketRequest request) throws ValidationException {
        checkEmpty(request.getTicketId(), "单证id不能为空");
        checkEmpty(request.getTicketCode(), "单证code不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(ReSendTicketRequest request) throws RuntimeException {
        return CommonResponse.failed("稽核发票不能下发");
        /*final IAuthorizedUser user = UserInfoHolder.get();
        final Map<String, Object> ticket = ticketService.selectByTicketCode(request.getTicketCode(), request.getTicketId());
        if (ValidatorUtil.isEmpty(ticket)) {
            return CommonResponse.failed("未查询到该单证");
        }
        final Long tenantId = Long.valueOf(String.valueOf(ticket.get("tenant_id")));
        final Long imageId = Long.valueOf(String.valueOf(ticket.get("image_id")));
        final Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("tenantId", tenantId);
        paramMap.put("imageId", imageId);
        rabbitmqUtils.sendByDirectExchange(MQEnum.SYNC_TICKET_QUEUE, paramMap);
        operationLogService.insertOperationLog(OperationEntity.TICKET.getCode(), StringHelp.safeToString(request.getTicketId()), OperationType.PUSH_TICKET.getCode(),
            user.getUsername(), "");
        return CommonResponse.ok("重新下发成功");*/
    }

}
