package com.xforceplus.elephant.image.controller.compare.ticket.process.deleteperson;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.DeleteTicketListRequest;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Dispatch(tenantCode = "seazen")
@Service
public class SEAZENCompareDeletePersonTicketListProcess extends DefaultCompareDeletePersonTicketListProcess {

    @Autowired
    private CompareBillImageTicketService billImageTicketService;
    @Autowired
    private CompareImageService imageService;

    @Override
    protected void check(DeleteTicketListRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getTicketIds())) {
            throw new ValidationException("单证ID集合【ticketIds】不能为空");
        }
        if (ValidatorUtil.isEmpty(request.getTicketCode())) {
            throw new ValidationException("单证code【ticketCode】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(DeleteTicketListRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        boolean result = false;
        //删除基础数据
        final Map<String, List<Long>> resultMap = billImageTicketService.deleteTicketData(
            authorizedUser.getTenantId(), request.getTicketIds(), request.getTicketCode());
        final List<Long> imageIds = resultMap.get("imageIds");
        final List<Long> ticketIds = resultMap.get("ticketIds");
        if (CollectionUtils.isEmpty(ticketIds)) {
            return CommonResponse.failed("没有找到可操作的数据");
        }

        //查询发票下挂接的附件，然后一并删除
        if (!CollectionUtils.isEmpty(imageIds)) {
            final List<Long> attachmentAndSalesImageId = imageService.selectTicketAttachmentAndSalesList(authorizedUser.getTenantId(), imageIds).stream().map(Image::getId)
                .collect(Collectors.toList());
            imageIds.addAll(attachmentAndSalesImageId);
        }

        if (!CollectionUtils.isEmpty(imageIds)) {
            //删除
            result = billImageTicketService.deleteImageAndTicketByImageIds(authorizedUser.getTenantId(), imageIds);
        }
        if (result) {
            String message = "删除成功";
            if (request.getTicketIds().size() != ticketIds.size()) {
                message = String.format("%d条记录成功删除%d条", request.getTicketIds().size(), ticketIds.size());
            }
            return CommonResponse.ok(message, true);
        } else {
            return CommonResponse.failed("无记录删除");
        }
    }

}