package com.xforceplus.elephant.image.controller.devops;

import com.xforceplus.elephant.basecommon.annotation.RedisLockMD5;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.model.ReTransformRequest;
import com.xforceplus.elephant.image.client.model.RestoreHookTicketRequest;
import com.xforceplus.elephant.image.client.model.TicketRelationHandleRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.devops.process.ReTransformProcess;
import com.xforceplus.elephant.image.controller.devops.process.RestoreHookTicketProcess;
import com.xforceplus.elephant.image.controller.devops.process.TicketRelationHandleProcess;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@ApiV1Image
@RequiredArgsConstructor
public class DevOpsController extends BaseController {

    private final ReTransformProcess reTransformProcess;
    private final RestoreHookTicketProcess restoreHookTicketProcess;
    private final TicketRelationHandleProcess ticketRelationHandleProcess;

    @RedisLockMD5
    @ApiOperation("失败文件重新发起转换")
    @PostMapping("/devops/reTransform")
    public CommonResponse<Boolean> reTransformBills(@RequestBody ReTransformRequest request) {
        return reTransformProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("单据维度恢复发票")
    @GetMapping("/devops/restoreHookTicket")
    public CommonResponse restoreHookTicket(RestoreHookTicketRequest request) {
        return restoreHookTicketProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("单证关系重算")
    @PostMapping("/devops/ticketRelationHandle")
    public CommonResponse<Boolean> ticketRelationHandle(@RequestBody TicketRelationHandleRequest request) {
        return ticketRelationHandleProcess.execute(request);
    }

}
