package com.xforceplus.elephant.image.controller.errorcode;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.ErrorCodeApi;
import com.xforceplus.elephant.image.core.facade.application.errorcode.ErrorCodeFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import lombok.RequiredArgsConstructor;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/6/14 15:17
 */
@ApiV1Image
@RequiredArgsConstructor
public class ErrorCodeController implements ErrorCodeApi {

    private final ErrorCodeFacade errorCodeFacade;

    @Override
    public CommonResponse listErrorCodes() {
        return CommonResponse.ok("success", errorCodeFacade.listProjectApiList(UserInfoHolder.get().getTenantCode()));
    }

    @Override
    public CommonResponse editErrorCodeMessage(final Long apiId, final String errorCode, final String message) {

        errorCodeFacade.editErrorCodeMessage(UserInfoHolder.get().getTenantCode(), apiId, errorCode, message);
        return CommonResponse.ok("success");
    }

}
