package com.xforceplus.elephant.image.controller.image;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.LoadingCache;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.annotation.NotLog;
import com.xforceplus.elephant.basecommon.annotation.RedisLockMD5;
import com.xforceplus.elephant.basecommon.enums.log.MethodTypeEnum;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.request.BatchRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.ImageApi;
import com.xforceplus.elephant.image.client.model.BillSelectAllRequest;
import com.xforceplus.elephant.image.client.model.CancelReturnImageRequest;
import com.xforceplus.elephant.image.client.model.CountRecStatusRequest;
import com.xforceplus.elephant.image.client.model.CutImageRequest;
import com.xforceplus.elephant.image.client.model.DownloadImageFileRequest;
import com.xforceplus.elephant.image.client.model.DownloadImageRequest;
import com.xforceplus.elephant.image.client.model.GetCoverImageListRequest;
import com.xforceplus.elephant.image.client.model.GetImageListRequest;
import com.xforceplus.elephant.image.client.model.GetImageReturnListRequest;
import com.xforceplus.elephant.image.client.model.GetImageStreamRequest;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.client.model.InsertBillImageRequest;
import com.xforceplus.elephant.image.client.model.InsertImageRequest;
import com.xforceplus.elephant.image.client.model.MoveImageRequest;
import com.xforceplus.elephant.image.client.model.ReturnImageRequest;
import com.xforceplus.elephant.image.client.model.RotateImageRequest;
import com.xforceplus.elephant.image.client.model.SaveImageOrCopyRequest;
import com.xforceplus.elephant.image.client.model.SaveImageRequest;
import com.xforceplus.elephant.image.client.model.SourceFileUploadRequest;
import com.xforceplus.elephant.image.client.model.UpdateImageRequest;
import com.xforceplus.elephant.image.client.model.UploadRequest;
import com.xforceplus.elephant.image.config.SentinelAlarm;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.image.process.CancelReturnImageProcess;
import com.xforceplus.elephant.image.controller.image.process.CountRecStatusProcess;
import com.xforceplus.elephant.image.controller.image.process.CutImageProcess;
import com.xforceplus.elephant.image.controller.image.process.DeleteCoverImageProcess;
import com.xforceplus.elephant.image.controller.image.process.DownloadImageFileProcess;
import com.xforceplus.elephant.image.controller.image.process.DownloadImagesProcess;
import com.xforceplus.elephant.image.controller.image.process.GetCoverImageListProcess;
import com.xforceplus.elephant.image.controller.image.process.GetImageDetailProcess;
import com.xforceplus.elephant.image.controller.image.process.GetImageReturnListProcess;
import com.xforceplus.elephant.image.controller.image.process.GetImageStreamProcess;
import com.xforceplus.elephant.image.controller.image.process.MoveImageProcess;
import com.xforceplus.elephant.image.controller.image.process.ReRecImageProcess;
import com.xforceplus.elephant.image.controller.image.process.ReTransfromImageProcess;
import com.xforceplus.elephant.image.controller.image.process.ResetImageProcess;
import com.xforceplus.elephant.image.controller.image.process.ReturnImageProcess;
import com.xforceplus.elephant.image.controller.image.process.RotateImageProcess;
import com.xforceplus.elephant.image.controller.image.process.SaveCoverImageProcess;
import com.xforceplus.elephant.image.controller.image.process.SaveImageOrCopyBase64Process;
import com.xforceplus.elephant.image.controller.image.process.SourceFileUploadProcess;
import com.xforceplus.elephant.image.controller.image.process.UploadAttachImageProcess;
import com.xforceplus.elephant.image.controller.image.process.UploadImageProcess;
import com.xforceplus.elephant.image.controller.image.process.UploadMessageProcess;
import com.xforceplus.elephant.image.controller.image.process.cover.DefaultReplaceCoverImageProcess;
import com.xforceplus.elephant.image.controller.image.process.delete.DefaultDeleteImageProcess;
import com.xforceplus.elephant.image.controller.image.process.imagelist.DefaultImageListProcess;
import com.xforceplus.elephant.image.controller.image.process.insertbillimage.DefaultInsertBillImageProcess;
import com.xforceplus.elephant.image.controller.image.process.insertimage.DefaultInsertImageProcess;
import com.xforceplus.elephant.image.controller.image.process.personsave.DefaultPersonSaveProcess;
import com.xforceplus.elephant.image.controller.image.process.saveimage.DefaultSaveImageProcess;
import com.xforceplus.elephant.image.controller.image.process.unhook.DefaultUnhookImageProcess;
import com.xforceplus.elephant.image.core.business.application.collect.image.domain.UploadMessageResult;
import com.xforceplus.elephant.image.core.business.util.MultiOQSUtil;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.image.bean.ImageSearchResultBean;
import com.xforceplus.tech.base.core.context.ContextKeys.StringKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class ImageController extends BaseController implements ImageApi {

    @Autowired
    private DefaultImageListProcess imageListProcess;
    @Autowired
    private GetImageDetailProcess getImageDetailProcess;
    @Autowired
    private GetImageStreamProcess getImageStreamProcess;
    @Autowired
    private SaveImageOrCopyBase64Process saveImageOrCopyBase64Process;
    @Autowired
    private ResetImageProcess resetImageProcess;
    @Autowired
    private ReturnImageProcess returnImageProcess;
    @Autowired
    private MoveImageProcess moveImageProcess;
    @Autowired
    private CountRecStatusProcess countRecStatusProcess;
    @Autowired
    private GetImageReturnListProcess getImageReturnListProcess;
    @Autowired
    private CancelReturnImageProcess cancelReturnImageProcess;
    @Autowired
    private SaveCoverImageProcess saveCoverImageProcess;
    @Autowired
    private ImageService imageService;
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;

    @Autowired
    private DefaultReplaceCoverImageProcess defaultReplaceCoverImageProcess;

    @Autowired
    private RotateImageProcess rotateImageProcess;
    @Autowired
    private DownloadImageFileProcess downloadImageFileProcess;
    @Autowired
    private UploadMessageProcess uploadMessageProcess;
    @Autowired
    private SentinelAlarm sentinelAlarm;
    @Autowired
    private CutImageProcess cutImageProcess;
    @Autowired
    private ReTransfromImageProcess reTransfromImageProcess;
    @Autowired
    private UploadAttachImageProcess uploadAttachImageProcess;
    @Autowired
    private UploadImageProcess uploadImageProcess;
    @Autowired
    private SourceFileUploadProcess sourceFileUploadProcess;
    @Autowired
    private GetCoverImageListProcess getCoverImageListProcess;
    @Autowired
    private DeleteCoverImageProcess deleteCoverImageProcess;
    @Autowired
    private DownloadImagesProcess downloadImagesProcess;
    @Autowired
    private ReRecImageProcess reRecImageProcess;
    @Autowired
    private LoadingCache<Long, Map<String, Integer>> userRecStatusCache;
    @Autowired
    private LoadingCache<String, Map<String, Integer>> billRecCountCache;
    @Autowired
    private MultiOQSUtil multiOQSUtil;
    @Autowired
    private ContextService contextService;

    @SentinelResource(value = "userRecStatus", fallback = "userRecStatusFallback")
    @MessageMapping("/userRecStatus/{userId}/{tenantId}")
    public void userRecStatus(@DestinationVariable("userId") final long userId, @DestinationVariable("tenantId") final long tenantId) throws ExecutionException {
        final List<Map<String, Integer>> objs = multiOQSUtil.call(() -> imageService.countRecStatusByCreateUserId(tenantId, userId));
        final Map<String, Integer> obj = objs.stream().filter(o -> o.values().stream().anyMatch(count -> count > 0)).findFirst().orElse(objs.get(0));
        if (obj.values().stream().anyMatch(count -> count > 0)) {
            userRecStatusCache.put(userId, obj);
        }
        simpMessagingTemplate.convertAndSend("/topic/user/" + userId, obj);
    }

    @SentinelResource(value = "userRecStatus", fallback = "userRecStatusFallback")
    @MessageMapping("/userRecStatus/{userId}")
    public void userRecStatus(@DestinationVariable("userId") final long userId) throws ExecutionException {
        final List<Map<String, Integer>> objs = multiOQSUtil.call(() -> imageService.countRecStatusByCreateUserId(0L, userId));
        final Map<String, Integer> obj = objs.stream().filter(o -> o.values().stream().anyMatch(count -> count > 0)).findFirst().orElse(objs.get(0));
        if (obj.values().stream().anyMatch(count -> count > 0)) {
            userRecStatusCache.put(userId, obj);
        }
        simpMessagingTemplate.convertAndSend("/topic/user/" + userId, obj);
    }

    public void userRecStatusFallback(final long userId, final BlockException blockException) {
        logger.debug("被限流，userId：{}", userId);
        simpMessagingTemplate.convertAndSend("/topic/user/" + userId, userRecStatusCache.getUnchecked(userId));
        logger.warn("sentinel flow limit:userRecStatus", blockException);
    }

    @SentinelResource(value = "billRecStatus", blockHandler = "billRecStatusFallback")
    @MessageMapping("/billRecStatus/{tenantId}/{billCode}")
    public void billRecStatus(@DestinationVariable("tenantId") final long tenantId, @DestinationVariable("billCode") final String billCode) throws ExecutionException {
        contextService.set(StringKeys.TENANTCODE_KEY, multiOQSUtil.getTenantCodeByTenantId(tenantId));
        try {
            final Map<String, Integer> obj = imageService.countRecStatusByBillCode(tenantId, billCode);
            if (obj.values().stream().anyMatch(count -> count > 0)) {
                logger.debug("开始缓存，billCode：{}, count:{}", billCode, obj);
                billRecCountCache.put(billCode, obj);
            }
            simpMessagingTemplate.convertAndSend("/topic/bill/" + billCode, obj);
        } finally {
            contextService.clear();
        }
    }

    private void billRecStatusFallback(final String billCode, final BlockException blockException) {
        logger.debug("被限流，billCode：{}", billCode);
        simpMessagingTemplate.convertAndSend("/topic/bill/" + billCode, billRecCountCache.getUnchecked(billCode));
        logger.warn("sentinel flow limit::billRecStatusFallback", blockException);
    }

    @Override
    @SentinelResource(value = "countRecStatus", blockHandler = "countRecStatusFallback")
    public CommonResponse<JSONObject> countRecStatus(final CountRecStatusRequest request) throws ExecutionException {
        final CommonResponse<JSONObject> response = countRecStatusProcess.execute(request);
        final Map<String, Integer> userCountMap = (Map<String, Integer>) response.getResult().get("user");
        if (userCountMap.values().stream().anyMatch(count -> count > 0)) {
            logger.debug("开始缓存，userId：{}, count:{}", UserInfoHolder.get().getId(), userCountMap);
            userRecStatusCache.put(UserInfoHolder.get().getId(), userCountMap);
        }
        final Map<String, Map<String, Integer>> billCountMap = (Map<String, Map<String, Integer>>) response.getResult().get("bill");
        if (ValidatorUtil.isNotEmpty(billCountMap)) {
            billCountMap.entrySet().forEach(entry -> {
                if (entry.getValue().values().stream().anyMatch(count -> count > 0)) {
                    billRecCountCache.put(entry.getKey(), entry.getValue());
                }
            });
        }
        return response;
    }

    public CommonResponse<JSONObject> countRecStatusFallback(final CountRecStatusRequest request, final BlockException blockException) throws ExecutionException {
        logger.debug("被限流，userId：{}", UserInfoHolder.get().getId());
        final JSONObject result = new JSONObject();
        result.put("user", userRecStatusCache.get(UserInfoHolder.get().getId()));
        if (ValidatorUtil.isNotEmpty(request.getBillCodes())) {
            logger.debug("被限流，billCode：{}", request.getBillCodes().stream().collect(Collectors.joining("、")));
            result.put("bill", request.getBillCodes().stream().distinct().collect(Collectors.toMap(Function.identity(), billCode -> {
                try {
                    return billRecCountCache.get(billCode);
                } catch (final ExecutionException e) {
                    logger.error("获取缓存异常", e);
                    return Collections.emptyMap();
                }
            })));
        }
        logger.warn("sentinel flow limit:countRecStatus", blockException);
        return CommonResponse.ok("成功", result);
    }

    @RedisLockMD5()
    @Override
    @LogApi(methodCode = "deleteImage", methodDescription = "删除影像信息",
        systemType = SystemTypeEnum.IMAGE, isRetry = 0, sender = SenderEnum.DEFAULT, receiver = ReceiverEnum.IMAGE, methodType = MethodTypeEnum.DELETE)
    public CommonResponse<Boolean> deleteImage(@RequestBody final BillSelectAllRequest request) {
        return process(DefaultDeleteImageProcess.class).execute(request);
    }

    @Override
    public CommonResponse<ImageDTO> getImageDetail(@PathVariable("imageId") final Long imageId, final BaseRequest request) {
        return getImageDetailProcess.execute(imageId, request);
    }

    @NotLog
    @AuthorizedDefinition(authorization = false)
    @CrossOrigin
    @Override
    public Object getImageFile(@PathVariable("imageId") final Long imageId, @PathVariable("fileExt") final String fileExt, final GetImageStreamRequest request) {
        return getImageStreamProcess.execute(imageId, request);
    }

    @Override
    public CommonResponse<ImageSearchResultBean> getImageList(final GetImageListRequest request) {
        return imageListProcess.execute(request);
    }

    @Override
    public CommonResponse getImageListPost(@RequestBody final GetImageListRequest request) {
        return imageListProcess.execute(request);
    }

    @Override
    public CommonResponse getImageReturnList(final GetImageReturnListRequest request) {
        return getImageReturnListProcess.execute(request);
    }

    @NotLog
    @AuthorizedDefinition(authorization = false)
    @CrossOrigin
    @Override
    public Object getImageStream(@PathVariable("imageId") final Long imageId, final GetImageStreamRequest request) {
        return getImageStreamProcess.execute(imageId, request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse insertImage(@RequestBody final InsertImageRequest request) {
        return process(DefaultInsertImageProcess.class).execute(request);
    }

    @Override
    public CommonResponse moveImage(@PathVariable("imageId") final Long imageId, @RequestBody final MoveImageRequest request) {
        return moveImageProcess.execute(imageId, request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse personSave(@RequestBody final SaveImageRequest request) {
        return process(DefaultPersonSaveProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse replaceCoverImage(@RequestBody final UpdateImageRequest request) {
        return process(DefaultReplaceCoverImageProcess.class).execute(request);
    }

    @Override
    public CommonResponse resetImage(@PathVariable("imageId") final Long imageId, @RequestBody final BaseRequest request) {
        return resetImageProcess.execute(imageId, request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse returnImage(@RequestBody final ReturnImageRequest request) {
        return returnImageProcess.execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse<List<Long>> saveImage(@RequestBody final SaveImageRequest request) {
        return process(DefaultSaveImageProcess.class).execute(request);
    }

    @Override
    public CommonResponse<Boolean> saveImageOrCopyByBase64(@PathVariable("imageId") final Long imageId, @RequestBody final SaveImageOrCopyRequest request) {
        return saveImageOrCopyBase64Process.execute(imageId, request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse unhookImage(@RequestBody final BillSelectAllRequest request) {
        return process(DefaultUnhookImageProcess.class).execute(request);
    }

    @RedisLockMD5()
    @Override
    public CommonResponse cancelReturnImage(@RequestBody final CancelReturnImageRequest request) {
        return cancelReturnImageProcess.execute(request);
    }

    @Override
    public CommonResponse rotateImage(final Long imageId, @RequestBody final RotateImageRequest request) {

        return rotateImageProcess.execute(imageId, request);
    }

    @Override
    public CommonResponse upload(@RequestBody final UploadRequest request) {
        return uploadImageProcess.execute(request);
    }

    @CrossOrigin
    @Override
    public Object downloadImageFile(final DownloadImageFileRequest request) {
        return downloadImageFileProcess.execute(request);
    }

    @Override
    public CommonResponse insertBillImage(@RequestBody final InsertBillImageRequest request) {
        return process(DefaultInsertBillImageProcess.class).execute(request);
    }

    @Override
    public CommonResponse<UploadMessageResult> uploadMessage(@Valid final BaseRequest request) {
        return uploadMessageProcess.execute(request);
    }

    @Override
    public CommonResponse<Long> cutImage(@RequestBody final CutImageRequest request) {
        return cutImageProcess.execute(request);
    }

    @Override
    public CommonResponse reTransfromImage(final BillSelectAllRequest request) {
        return reTransfromImageProcess.execute(request);
    }

    @Override
    public CommonResponse uploadAttachment(final UploadRequest request) {
        return uploadAttachImageProcess.execute(request);
    }

    @Override
    public CommonResponse sourceFileUpload(@RequestBody final SourceFileUploadRequest request) {
        return sourceFileUploadProcess.execute(request);
    }

    @Override
    public CommonResponse getCoverImageList(@Valid final GetCoverImageListRequest request) {
        return getCoverImageListProcess.execute(request);
    }

    @Override
    public CommonResponse saveCoverImage(@RequestBody final SaveImageRequest request) {
        return saveCoverImageProcess.execute(request);
    }

    @Override
    public CommonResponse deleteCoverImage(@PathVariable("imageId") final Long imageId, @RequestBody final BaseRequest request) {
        return deleteCoverImageProcess.execute(imageId, request);
    }

    @RedisLockMD5
    @ApiOperation("批量下载勾选影像")
    @RequestMapping(value = "/image/downloadImage", produces = {"application/json"}, method = RequestMethod.POST)
    public CommonResponse downloadImages(@RequestBody final DownloadImageRequest request) {
        return downloadImagesProcess.execute(request);
    }

    @RedisLockMD5
    @ApiOperation("重新识别发票")
    @RequestMapping(value = "/image/reRecImage", produces = {"application/json"}, method = RequestMethod.POST)
    public CommonResponse reRecImage(@RequestBody final BatchRequest request) {
        return reRecImageProcess.execute(request);
    }

}