package com.xforceplus.elephant.image.controller.image.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.CountRecStatusRequest;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CountRecStatusProcess extends AbstractProcess<CountRecStatusRequest, JSONObject> {

    @Autowired
    private ImageService imageService;

    @Override
    protected CommonResponse<JSONObject> process(CountRecStatusRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final JSONObject result = new JSONObject();
        final Map<String, Integer> userCountMap = imageService.countRecStatusByCreateUserId(authorizedUser.getTenantId(), authorizedUser.getId());
        result.put("user", userCountMap);
        if (ValidatorUtil.isEmpty(request.getBillCodes())) {
            return CommonResponse.ok("成功", result);
        }
        final Map<String, Map<String, Integer>> billCountMap = request.getBillCodes().stream()
                                                                      .distinct()
                                                                      .collect(Collectors.toMap(Function.identity(),
                                                                          billCode -> imageService.countRecStatusByBillCode(authorizedUser.getTenantId(), billCode)));
        result.put("bill", billCountMap);
        return CommonResponse.ok("成功", result);
    }

}