package com.xforceplus.elephant.image.controller.image.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetCoverImageListRequest;
import com.xforceplus.elephant.image.core.facade.application.collect.image.ImageFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 获取封面影像
 *
 * @author rongying
 * @date 2021/5/18 15:57
 */
@Service
public class GetCoverImageListProcess extends AbstractProcess<GetCoverImageListRequest, List<Image>> {

    @Autowired
    private ImageFacade imageFacade;

    @Override
    protected void check(GetCoverImageListRequest request) throws ValidationException {
        checkEmpty(request.getBillCode(), "业务单号不能为空!");
    }

    @Override
    protected CommonResponse<List<Image>> process(GetCoverImageListRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final List<Image> imageList = imageFacade.selectCoverImageList(authorizedUser.getTenantId(), request.getBillCode(), EntityMeta.Image.code());
        return CommonResponse.ok("成功", imageList);
    }

}
