package com.xforceplus.elephant.image.controller.image.process;

import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.client.model.UpdateImageRequest;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReplaceCoverImageProcess extends AbstractKeyProcess<String, UpdateImageRequest, Boolean> {

    @Autowired
    private ImageService imageService;

    @Override
    protected void check(String billCode, UpdateImageRequest request) throws ValidationException {
        super.check(billCode, request);
        checkEmpty(request.getEntities(), "封面不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(String billCode, UpdateImageRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final Image entity = imageService.selectCoverByBillCode(authorizedUser.getTenantId(), billCode);
        if (entity == null) {
            return CommonResponse.failed("当前单据没有封面无法替换");
        }
        final ImageDTO newImage = request.getEntities().get(request.getEntities().size() - 1);
        final boolean result = imageService.updateImageFileUrl(authorizedUser.getTenantId(), entity.getId(),
            newImage.getFileUrlHandle(), newImage.getFileTypeHandle(), authorizedUser.getId(),
            authorizedUser.getUsername());
        return CommonResponse.ok("成功", result);
    }

}
