package com.xforceplus.elephant.image.controller.image.process;

import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResetImageProcess extends AbstractKeyProcess<Long, BaseRequest, Boolean> {

    @Autowired
    private ImageService imageService;

    @Override
    protected CommonResponse<Boolean> process(Long imageId, BaseRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final boolean result = imageService.unCoverImage(authorizedUser.getTenantId(), imageId);
        return CommonResponse.ok("成功", result);
    }

}
